/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.junitbenchmarks.db;

import com.carrotsearch.junitbenchmarks.Escape;
import com.carrotsearch.junitbenchmarks.db.DbConsumer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class GeneratorUtils {
    private static final Pattern CLASSNAME_PATTERN = Pattern.compile("CLASSNAME", 16);

    GeneratorUtils() {
    }

    public static int getColumnIndex(ResultSet rs, String label) throws SQLException {
        ResultSetMetaData md = rs.getMetaData();
        for (int i = 1; i <= md.getColumnCount(); ++i) {
            if (!label.equals(md.getColumnLabel(i))) continue;
            return i;
        }
        throw new RuntimeException("No column labeled: " + label);
    }

    static String getProperties(DbConsumer consumer) throws SQLException {
        Connection connection = consumer.getConnection();
        int runId = consumer.getRunId();
        StringBuilder buf = new StringBuilder();
        PreparedStatement s = connection.prepareStatement(consumer.getMethodChartPropertiesQuery());
        s.setInt(1, runId);
        ResultSet rs = s.executeQuery();
        ResultSetMetaData metaData = rs.getMetaData();
        while (rs.next()) {
            for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                Object obj = rs.getObject(i);
                if (obj == null) continue;
                buf.append(metaData.getColumnLabel(i));
                buf.append(": ");
                buf.append(obj);
                buf.append("\n");
            }
        }
        rs.close();
        s.close();
        return Escape.htmlEscape(buf.toString());
    }

    static Object formatValue(int sqlColumnType, Object val) {
        switch (sqlColumnType) {
            case 12: {
                return "\"" + Escape.jsonEscape(val.toString()) + "\"";
            }
            case -6: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                return val;
            }
        }
        throw new RuntimeException("Unsupported column type: " + sqlColumnType);
    }

    public static String getMappedType(int sqlColumnType) {
        switch (sqlColumnType) {
            case 12: {
                return "string";
            }
            case -6: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                return "number";
            }
        }
        throw new RuntimeException("Unsupported column type: " + sqlColumnType);
    }

    static String replaceToken(String template, String key, String replacement) {
        Pattern p = Pattern.compile(key, 16);
        return p.matcher(template).replaceAll(Matcher.quoteReplacement(replacement));
    }

    static void save(String fileName, String content) throws IOException {
        File file = new File(fileName);
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        FileOutputStream fos = new FileOutputStream(file);
        fos.write(content.getBytes("UTF-8"));
        fos.close();
    }

    static String getMinMax(double min, double max) {
        StringBuilder b = new StringBuilder();
        if (!Double.isNaN(min)) {
            b.append("min: " + min + ",");
        }
        if (!Double.isNaN(max)) {
            b.append("max: " + max + ",");
        }
        return b.toString();
    }

    public static String getFilePrefix(Class<?> clazz, String filePrefix, File chartsDir) {
        if (filePrefix == null || filePrefix.trim().equals("")) {
            filePrefix = clazz.getName();
        }
        if (!new File(filePrefix = CLASSNAME_PATTERN.matcher(filePrefix).replaceAll(Matcher.quoteReplacement(clazz.getName()))).isAbsolute()) {
            filePrefix = new File(chartsDir, filePrefix).getAbsolutePath();
        }
        return filePrefix;
    }
}

