/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.randomizedtesting;

import com.carrotsearch.randomizedtesting.AssertingRandom;
import com.carrotsearch.randomizedtesting.SeedDecorator;
import com.carrotsearch.randomizedtesting.SeedUtils;
import java.util.Random;

public final class Randomness {
    private final long seed;
    private final AssertingRandom random;
    private SeedDecorator[] decorators;

    public Randomness(Thread owner, long seed, SeedDecorator ... decorators) {
        this.seed = seed;
        this.decorators = decorators;
        this.random = new AssertingRandom(owner, new Random(Randomness.decorate(seed, decorators)));
    }

    public Randomness(long seed, SeedDecorator ... decorators) {
        this(Thread.currentThread(), seed, decorators);
    }

    public Random getRandom() {
        return this.random;
    }

    Randomness clone(Thread newOwner) {
        return new Randomness(newOwner, this.seed, this.decorators);
    }

    public String toString() {
        return "[Randomness, seed=" + SeedUtils.formatSeedChain(this) + "]";
    }

    void destroy() {
        this.random.destroy();
    }

    long getSeed() {
        return this.seed;
    }

    private static long decorate(long seed, SeedDecorator[] decorators) {
        for (SeedDecorator decorator : decorators) {
            seed = decorator.decorate(seed);
        }
        return seed;
    }
}

