/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.netlet;

import com.datatorrent.netlet.AbstractClient;
import com.datatorrent.netlet.EventLoop;
import com.datatorrent.netlet.util.VarInt;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLengthPrependerClient
extends AbstractClient {
    protected byte[] buffer;
    protected ByteBuffer byteBuffer;
    protected int size;
    protected int writeOffset;
    protected int readOffset;
    private int intOffset;
    private static final int INT_ARRAY_SIZE = 4091;
    private byte[] intBuffer = new byte[4096];
    private static final Logger logger = LoggerFactory.getLogger(AbstractLengthPrependerClient.class);

    public AbstractLengthPrependerClient() {
        this(new byte[65536], 0, 1024);
    }

    public AbstractLengthPrependerClient(int readBufferSize, int sendBufferSize) {
        this(new byte[readBufferSize], 0, sendBufferSize);
    }

    public AbstractLengthPrependerClient(byte[] readbuffer, int position, int sendBufferSize) {
        super(sendBufferSize);
        this.buffer = readbuffer;
        this.byteBuffer = ByteBuffer.wrap(readbuffer);
        this.byteBuffer.position(position);
        this.writeOffset = position;
        this.readOffset = position;
    }

    @Override
    public ByteBuffer buffer() {
        return this.byteBuffer;
    }

    public int readSize() {
        if (this.readOffset < this.writeOffset) {
            byte tmp;
            int offset = this.readOffset;
            if ((tmp = this.buffer[this.readOffset++]) >= 0) {
                return tmp;
            }
            if (this.readOffset < this.writeOffset) {
                int integer = tmp & 0x7F;
                if ((tmp = this.buffer[this.readOffset++]) >= 0) {
                    return integer | tmp << 7;
                }
                if (this.readOffset < this.writeOffset) {
                    integer |= (tmp & 0x7F) << 7;
                    if ((tmp = this.buffer[this.readOffset++]) >= 0) {
                        return integer | tmp << 14;
                    }
                    if (this.readOffset < this.writeOffset) {
                        integer |= (tmp & 0x7F) << 14;
                        if ((tmp = this.buffer[this.readOffset++]) >= 0) {
                            return integer | tmp << 21;
                        }
                        if (this.readOffset < this.writeOffset) {
                            integer |= (tmp & 0x7F) << 21;
                            if ((tmp = this.buffer[this.readOffset++]) >= 0) {
                                return integer | tmp << 28;
                            }
                            throw new NumberFormatException("Invalid varint at location " + offset + " => " + Arrays.toString(Arrays.copyOfRange(this.buffer, offset, this.readOffset)));
                        }
                    }
                }
            }
            this.readOffset = offset;
        }
        return -1;
    }

    @Override
    public void read(int len) {
        this.beginMessage();
        this.writeOffset += len;
        while (true) {
            if (this.size == 0) {
                this.size = this.readSize();
                if (this.size != -1) continue;
                if (this.writeOffset == this.buffer.length && this.readOffset > this.writeOffset - 5) {
                    byte[] newArray = new byte[this.buffer.length];
                    System.arraycopy(this.buffer, this.readOffset, newArray, 0, this.writeOffset - this.readOffset);
                    this.buffer = newArray;
                    this.writeOffset -= this.readOffset;
                    this.readOffset = 0;
                    this.byteBuffer = ByteBuffer.wrap(this.buffer);
                    this.byteBuffer.position(this.writeOffset);
                }
                this.size = 0;
                this.endMessage();
                return;
            }
            if (this.writeOffset - this.readOffset < this.size) break;
            this.onMessage(this.buffer, this.readOffset, this.size);
            this.readOffset += this.size;
            this.size = 0;
        }
        if (this.writeOffset == this.buffer.length) {
            if (this.size > this.buffer.length) {
                int newsize;
                for (newsize = this.buffer.length; newsize < this.size; newsize <<= 1) {
                }
                byte[] newArray = new byte[newsize];
                System.arraycopy(this.buffer, this.readOffset, newArray, 0, this.writeOffset - this.readOffset);
                this.buffer = newArray;
                this.writeOffset -= this.readOffset;
                this.readOffset = 0;
                this.byteBuffer = ByteBuffer.wrap(newArray);
                this.byteBuffer.position(this.writeOffset);
            } else {
                byte[] newArray = new byte[this.buffer.length];
                System.arraycopy(this.buffer, this.readOffset, newArray, 0, this.writeOffset - this.readOffset);
                this.buffer = newArray;
                this.writeOffset -= this.readOffset;
                this.readOffset = 0;
                this.byteBuffer = ByteBuffer.wrap(this.buffer);
                this.byteBuffer.position(this.writeOffset);
            }
            this.endMessage();
            return;
        }
        this.endMessage();
    }

    public boolean write(byte[] message) {
        return this.write(message, 0, message.length);
    }

    public boolean write(byte[] message1, byte[] message2) {
        int newOffset;
        if (this.sendBuffer4Offers.remainingCapacity() < 3 && this.sendBuffer4Offers.capacity() == MAX_SENDBUFFER_SIZE) {
            return false;
        }
        if (this.intOffset > 4091) {
            this.intBuffer = new byte[4096];
            this.intOffset = 0;
        }
        if (this.send(this.intBuffer, this.intOffset, (newOffset = VarInt.write(message1.length + message2.length, this.intBuffer, this.intOffset)) - this.intOffset)) {
            this.intOffset = newOffset;
            if (this.send(message1, 0, message1.length) && this.send(message2, 0, message2.length)) {
                return true;
            }
            logger.debug("Exiting sendBuffer for Offers = {}, socket = {}", (Object)this.sendBuffer4Offers, (Object)this.key.channel());
            System.exit(0);
            throw new IllegalStateException("Only partial data could be written!");
        }
        logger.debug("sendBuffer for Offers = {}, socket = {}", (Object)this.sendBuffer4Offers, (Object)this.key.channel());
        return false;
    }

    public boolean write(byte[] message, int offset, int size) {
        int newOffset;
        if (this.sendBuffer4Offers.remainingCapacity() < 2 && this.sendBuffer4Offers.capacity() == MAX_SENDBUFFER_SIZE) {
            return false;
        }
        if (this.intOffset > 4091) {
            this.intBuffer = new byte[4096];
            this.intOffset = 0;
        }
        if (this.send(this.intBuffer, this.intOffset, (newOffset = VarInt.write(size, this.intBuffer, this.intOffset)) - this.intOffset)) {
            this.intOffset = newOffset;
            if (this.send(message, offset, size)) {
                return true;
            }
            logger.debug("Exiting sendBuffer for Offers = {}, socket = {}", (Object)this.sendBuffer4Offers, (Object)this.key.channel());
            System.exit(0);
            throw new IllegalStateException("Only partial data could be written!");
        }
        return false;
    }

    public void beginMessage() {
    }

    protected void discardReadBuffer() {
        this.readOffset = this.writeOffset - this.size;
    }

    public abstract void onMessage(byte[] var1, int var2, int var3);

    public void endMessage() {
    }

    @Override
    public void handleException(Exception cce, EventLoop el) {
        if (!this.key.isValid()) {
            super.handleException(cce, el);
        } else if (this.key.attachment() == this) {
            if (cce instanceof IOException) {
                logger.error("Disconnecting {} because of an exception.", (Object)this, (Object)cce);
                if (this.isConnected()) {
                    el.disconnect(this);
                }
            } else {
                super.handleException(cce, el);
            }
        } else {
            logger.error("Ignoring exception received after discarding the connection.", (Throwable)cce);
        }
    }
}

