/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.netlet;

import com.datatorrent.netlet.EventLoop;

public interface NetletThrowable {
    public EventLoop getEventLoop();

    public Throwable getCause();

    public static class NetletRuntimeException
    extends RuntimeException
    implements NetletThrowable {
        public final transient EventLoop eventloop;
        private static final long serialVersionUID = 201401221638L;

        public NetletRuntimeException(RuntimeException exception, EventLoop el) {
            super(exception);
            this.eventloop = el;
        }

        @Override
        public EventLoop getEventLoop() {
            return this.eventloop;
        }
    }

    public static class NetletException
    extends Exception
    implements NetletThrowable {
        public final transient EventLoop eventloop;
        private static final long serialVersionUID = 201401221635L;

        public NetletException(Exception exception, EventLoop el) {
            super(exception);
            this.eventloop = el;
        }

        @Override
        public EventLoop getEventLoop() {
            return this.eventloop;
        }
    }

    public static class NetletError
    extends Error
    implements NetletThrowable {
        public final transient EventLoop eventloop;
        private static final long serialVersionUID = 201401221632L;

        public NetletError(Error error, EventLoop el) {
            super(error);
            this.eventloop = el;
        }

        @Override
        public EventLoop getEventLoop() {
            return this.eventloop;
        }
    }

    public static class Util {
        public static NetletThrowable rewrap(Throwable th, EventLoop el) {
            if (th instanceof NetletThrowable) {
                NetletThrowable nth = (NetletThrowable)((Object)th);
                if (el == nth.getEventLoop()) {
                    return nth;
                }
                return Util.rewrap(nth.getCause(), el);
            }
            if (th instanceof Error) {
                return new NetletError((Error)th, el);
            }
            if (th instanceof RuntimeException) {
                return new NetletRuntimeException((RuntimeException)th, el);
            }
            return new NetletException((Exception)th, el);
        }

        public static void throwRuntime(NetletThrowable cause) {
            if (cause instanceof NetletError) {
                throw (NetletError)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (NetletRuntimeException)cause;
            }
            throw new NetletRuntimeException(new RuntimeException(cause.getCause()), cause.getEventLoop());
        }

        public static void rethrow(NetletThrowable cause) throws NetletException {
            if (cause instanceof NetletError) {
                throw (NetletError)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (NetletRuntimeException)cause;
            }
            throw (NetletException)cause;
        }
    }
}

