/*
 * Decompiled with CFR 0.152.
 */
package com.dreizak.miniball.highdim;

import com.dreizak.miniball.highdim.Quality;
import com.dreizak.miniball.highdim.Subspan;
import com.dreizak.miniball.model.PointSet;
import java.util.List;

public class Miniball {
    private static final double Eps = 1.0E-14;
    private final PointSet S;
    private final int size;
    private final int dim;
    private int iteration;
    private final double[] center;
    private final double[] centerToAff;
    private final double[] centerToPoint;
    private final double[] lambdas;
    private double distToAff;
    private double distToAffSquare;
    private double squaredRadius;
    private double radius;
    private final Subspan support;
    private int stopper;

    public Miniball(PointSet pts) {
        this.S = pts;
        this.size = this.S.size();
        this.dim = this.S.dimension();
        this.center = new double[this.dim];
        this.centerToAff = new double[this.dim];
        this.centerToPoint = new double[this.dim];
        this.lambdas = new double[this.dim + 1];
        this.support = this.initBall();
        this.compute();
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public double radius() {
        return this.radius;
    }

    public double squaredRadius() {
        return this.squaredRadius;
    }

    public double[] center() {
        return this.center;
    }

    public int size() {
        return this.size;
    }

    public List<Integer> support() {
        throw new RuntimeException("Not implemented yet.");
    }

    private static double sqr(double x) {
        return x * x;
    }

    private Subspan initBall() {
        assert (this.size > 0);
        for (int i = 0; i < this.dim; ++i) {
            this.center[i] = this.S.coord(0, i);
        }
        this.squaredRadius = 0.0;
        int farthest = 0;
        for (int j = 1; j < this.S.size(); ++j) {
            double dist = 0.0;
            for (int i = 0; i < this.dim; ++i) {
                dist += Miniball.sqr(this.S.coord(j, i) - this.center[i]);
            }
            if (!(dist >= this.squaredRadius)) continue;
            this.squaredRadius = dist;
            farthest = j;
        }
        this.radius = Math.sqrt(this.squaredRadius);
        return new Subspan(this.dim, this.S, farthest);
    }

    private void computeDistToAff() {
        this.distToAffSquare = this.support.shortestVectorToSpan(this.center, this.centerToAff);
        this.distToAff = Math.sqrt(this.distToAffSquare);
    }

    private void updateRadius() {
        int any = this.support.anyMember();
        this.squaredRadius = 0.0;
        for (int i = 0; i < this.dim; ++i) {
            this.squaredRadius += Miniball.sqr(this.S.coord(any, i) - this.center[i]);
        }
        this.radius = Math.sqrt(this.squaredRadius);
    }

    private void compute() {
        while (true) {
            int i;
            ++this.iteration;
            this.computeDistToAff();
            while (this.distToAff <= 1.0E-14 * this.radius || this.support.size() == this.dim + 1) {
                if (!this.successfulDrop()) {
                    return;
                }
                this.computeDistToAff();
            }
            double scale = this.findStopFraction();
            if (this.stopper >= 0) {
                for (i = 0; i < this.dim; ++i) {
                    int n = i;
                    this.center[n] = this.center[n] + scale * this.centerToAff[i];
                }
                this.updateRadius();
                this.support.add(this.stopper);
                continue;
            }
            for (i = 0; i < this.dim; ++i) {
                int n = i;
                this.center[n] = this.center[n] + this.centerToAff[i];
            }
            this.updateRadius();
            if (!this.successfulDrop()) break;
        }
    }

    boolean successfulDrop() {
        this.support.findAffineCoefficients(this.center, this.lambdas);
        int smallest = 0;
        double minimum = 1.0;
        for (int i = 0; i < this.support.size(); ++i) {
            if (!(this.lambdas[i] < minimum)) continue;
            minimum = this.lambdas[i];
            smallest = i;
        }
        if (minimum <= 0.0) {
            this.support.remove(smallest);
            return true;
        }
        return false;
    }

    private double findStopFraction() {
        double scale = 1.0;
        this.stopper = -1;
        for (int j = 0; j < this.size; ++j) {
            if (this.support.isMember(j)) continue;
            for (int i = 0; i < this.dim; ++i) {
                this.centerToPoint[i] = this.S.coord(j, i) - this.center[i];
            }
            double dirPointProd = 0.0;
            for (int i = 0; i < this.dim; ++i) {
                dirPointProd += this.centerToAff[i] * this.centerToPoint[i];
            }
            if (this.distToAffSquare - dirPointProd < 1.0E-14 * this.radius * this.distToAff) continue;
            double bound = 0.0;
            for (int i = 0; i < this.dim; ++i) {
                bound += this.centerToPoint[i] * this.centerToPoint[i];
            }
            if (!((bound = (this.squaredRadius - bound) / 2.0 / (this.distToAffSquare - dirPointProd)) < scale)) continue;
            scale = bound;
            this.stopper = j;
        }
        return scale;
    }

    public Quality verify() {
        int k;
        double min_lambda = 1.0;
        double max_overlength = 0.0;
        double min_underlength = 0.0;
        double qr_error = this.support.representationError();
        this.support.findAffineCoefficients(this.center, this.lambdas);
        for (k = 0; k < this.support.size(); ++k) {
            if (!(this.lambdas[k] <= min_lambda)) continue;
            min_lambda = this.lambdas[k];
        }
        for (k = 0; k < this.S.size(); ++k) {
            for (int i = 0; i < this.dim; ++i) {
                this.centerToPoint[i] = this.S.coord(k, i) - this.center[i];
            }
            double sqDist = 0.0;
            for (int i = 0; i < this.dim; ++i) {
                sqDist += Miniball.sqr(this.centerToPoint[i]);
            }
            double ball_error = Math.sqrt(sqDist) - this.radius;
            if (ball_error > max_overlength) {
                max_overlength = ball_error;
            }
            if (!this.support.isMember(k) || !(ball_error < min_underlength)) continue;
            min_underlength = ball_error;
        }
        return new Quality(qr_error, min_lambda, max_overlength / this.radius, Math.abs(min_underlength / this.radius), this.iteration, this.support.size());
    }

    public String toString() {
        StringBuilder s = new StringBuilder("Miniball [");
        if (this.isEmpty()) {
            s.append("isEmpty=true");
        } else {
            s.append("center=(");
            for (int i = 0; i < this.dim; ++i) {
                s.append(this.center[i]);
                if (i >= this.dim - 1) continue;
                s.append(", ");
            }
            s.append("), radius=").append(this.radius).append(", squaredRadius=").append(this.squaredRadius).append(", quality=").append(this.verify());
        }
        return s.append("]").toString();
    }
}

