/*
 * Decompiled with CFR 0.152.
 */
package com.dreizak.miniball.highdim;

import com.dreizak.miniball.highdim.Logging;
import com.dreizak.miniball.model.PointSet;
import java.util.BitSet;

final class Subspan {
    private final PointSet S;
    private final BitSet membership;
    private final int dim;
    private final int[] members;
    private final double[][] Q;
    private final double[][] R;
    private final double[] u;
    private final double[] w;
    private int r;
    private double c;
    private double s;

    Subspan(int dim, PointSet S, int k) {
        int i;
        this.S = S;
        this.dim = dim;
        this.membership = new BitSet(S.size());
        this.members = new int[dim + 1];
        this.r = 0;
        this.Q = new double[dim][];
        this.R = new double[dim][];
        for (i = 0; i < dim; ++i) {
            this.Q[i] = new double[dim];
            this.R[i] = new double[dim];
        }
        this.u = new double[dim];
        this.w = new double[dim];
        for (i = 0; i < dim; ++i) {
            for (int j = 0; j < dim; ++j) {
                this.Q[j][i] = i == j ? 1.0 : 0.0;
            }
        }
        this.members[this.r] = k;
        this.membership.set(k);
    }

    public int dimension() {
        return this.dim;
    }

    public int size() {
        return this.r + 1;
    }

    public boolean isMember(int i) {
        assert (0 <= i && i < this.S.size());
        return this.membership.get(i);
    }

    public int anyMember() {
        assert (this.size() > 0);
        return this.members[this.r];
    }

    public int globalIndex(int i) {
        assert (0 <= i && i < this.size());
        return this.members[i];
    }

    private final int ind(int i, int j) {
        return i * this.dim + j;
    }

    private final int origin() {
        return this.members[this.r];
    }

    private final void givens(double a, double b) {
        if (b == 0.0) {
            this.c = 1.0;
            this.s = 0.0;
        } else if (Math.abs(b) > Math.abs(a)) {
            double t = a / b;
            this.s = 1.0 / Math.sqrt(1.0 + t * t);
            this.c = this.s * t;
        } else {
            double t = b / a;
            this.c = 1.0 / Math.sqrt(1.0 + t * t);
            this.s = this.c * t;
        }
    }

    private void appendColumn() {
        assert (this.r < this.dim);
        for (int i = 0; i < this.dim; ++i) {
            this.R[this.r][i] = 0.0;
            for (int k = 0; k < this.dim; ++k) {
                double[] dArray = this.R[this.r];
                int n = i;
                dArray[n] = dArray[n] + this.Q[i][k] * this.u[k];
            }
        }
        for (int j = this.dim - 1; j > this.r; --j) {
            this.givens(this.R[this.r][j - 1], this.R[this.r][j]);
            this.R[this.r][j - 1] = this.c * this.R[this.r][j - 1] + this.s * this.R[this.r][j];
            for (int i = 0; i < this.dim; ++i) {
                double a = this.Q[j - 1][i];
                double b = this.Q[j][i];
                this.Q[j - 1][i] = this.c * a + this.s * b;
                this.Q[j][i] = this.c * b - this.s * a;
            }
        }
    }

    public void add(int index) {
        assert (!this.isMember(index));
        int o = this.origin();
        for (int i = 0; i < this.dim; ++i) {
            this.u[i] = this.S.coord(index, i) - this.S.coord(o, i);
        }
        this.appendColumn();
        this.membership.set(index);
        this.members[this.r + 1] = this.members[this.r];
        this.members[this.r] = index;
        ++this.r;
        Logging.info("rank: " + this.r);
    }

    public double shortestVectorToSpan(double[] p, double[] w) {
        int o = this.origin();
        for (int i = 0; i < this.dim; ++i) {
            w[i] = this.S.coord(o, i) - p[i];
        }
        for (int j = 0; j < this.r; ++j) {
            int i;
            double scale = 0.0;
            for (i = 0; i < this.dim; ++i) {
                scale += w[i] * this.Q[j][i];
            }
            for (i = 0; i < this.dim; ++i) {
                int n = i;
                w[n] = w[n] - scale * this.Q[j][i];
            }
        }
        double sl = 0.0;
        for (int i = 0; i < this.dim; ++i) {
            sl += w[i] * w[i];
        }
        return sl;
    }

    public double representationError() {
        double[] lambdas = new double[this.size()];
        double[] pt = new double[this.dim];
        double max = 0.0;
        for (int j = 0; j < this.size(); ++j) {
            int i;
            for (i = 0; i < this.dim; ++i) {
                pt[i] = this.S.coord(this.globalIndex(j), i);
            }
            this.findAffineCoefficients(pt, lambdas);
            double error = Math.abs(lambdas[j] - 1.0);
            if (error > max) {
                max = error;
            }
            for (i = 0; i < j; ++i) {
                error = Math.abs(lambdas[i] - 0.0);
                if (!(error > max)) continue;
                max = error;
            }
            for (i = j + 1; i < this.size(); ++i) {
                error = Math.abs(lambdas[i] - 0.0);
                if (!(error > max)) continue;
                max = error;
            }
        }
        return max;
    }

    void findAffineCoefficients(double[] p, double[] lambdas) {
        int i;
        int o = this.origin();
        for (i = 0; i < this.dim; ++i) {
            this.u[i] = p[i] - this.S.coord(o, i);
        }
        for (i = 0; i < this.dim; ++i) {
            this.w[i] = 0.0;
            for (int k = 0; k < this.dim; ++k) {
                int n = i;
                this.w[n] = this.w[n] + this.Q[i][k] * this.u[k];
            }
        }
        double origin_lambda = 1.0;
        for (int j = this.r - 1; j >= 0; --j) {
            double lj;
            for (int k = j + 1; k < this.r; ++k) {
                int n = j;
                this.w[n] = this.w[n] - lambdas[k] * this.R[k][j];
            }
            lambdas[j] = lj = this.w[j] / this.R[j][j];
            origin_lambda -= lj;
        }
        lambdas[this.r] = origin_lambda;
    }

    private void hessenberg_clear(int pos) {
        while (pos < this.r) {
            double b;
            double a;
            this.givens(this.R[pos][pos], this.R[pos][pos + 1]);
            this.R[pos][pos] = this.c * this.R[pos][pos] + this.s * this.R[pos][pos + 1];
            for (int j = pos + 1; j < this.r; ++j) {
                a = this.R[j][pos];
                b = this.R[j][pos + 1];
                this.R[j][pos] = this.c * a + this.s * b;
                this.R[j][pos + 1] = this.c * b - this.s * a;
            }
            for (int i = 0; i < this.dim; ++i) {
                a = this.Q[pos][i];
                b = this.Q[pos + 1][i];
                this.Q[pos][i] = this.c * a + this.s * b;
                this.Q[pos + 1][i] = this.c * b - this.s * a;
            }
            ++pos;
        }
    }

    private void special_rank_1_update() {
        for (int i = 0; i < this.dim; ++i) {
            this.w[i] = 0.0;
            for (int k = 0; k < this.dim; ++k) {
                int n = i;
                this.w[n] = this.w[n] + this.Q[i][k] * this.u[k];
            }
        }
        for (int k = this.dim - 1; k > 0; --k) {
            double b;
            double a;
            this.givens(this.w[k - 1], this.w[k]);
            this.w[k - 1] = this.c * this.w[k - 1] + this.s * this.w[k];
            this.R[k - 1][k] = -this.s * this.R[k - 1][k - 1];
            double[] dArray = this.R[k - 1];
            int n = k - 1;
            dArray[n] = dArray[n] * this.c;
            for (int j = k; j < this.r; ++j) {
                a = this.R[j][k - 1];
                b = this.R[j][k];
                this.R[j][k - 1] = this.c * a + this.s * b;
                this.R[j][k] = this.c * b - this.s * a;
            }
            for (int i = 0; i < this.dim; ++i) {
                a = this.Q[k - 1][i];
                b = this.Q[k][i];
                this.Q[k - 1][i] = this.c * a + this.s * b;
                this.Q[k][i] = this.c * b - this.s * a;
            }
        }
        for (int j = 0; j < this.r; ++j) {
            double[] dArray = this.R[j];
            dArray[0] = dArray[0] + this.w[0];
        }
        this.hessenberg_clear(0);
    }

    public void remove(int index) {
        assert (this.isMember(this.globalIndex(index)) && this.size() > 1);
        this.membership.clear(this.globalIndex(index));
        if (index == this.r) {
            int o = this.origin();
            int gi = this.globalIndex(this.r - 1);
            for (int i = 0; i < this.dim; ++i) {
                this.u[i] = this.S.coord(o, i) - this.S.coord(gi, i);
            }
            --this.r;
            this.special_rank_1_update();
        } else {
            double[] dummy = this.R[index];
            for (int j = index + 1; j < this.r; ++j) {
                this.R[j - 1] = this.R[j];
                this.members[j - 1] = this.members[j];
            }
            this.members[this.r - 1] = this.members[this.r];
            this.R[--this.r] = dummy;
            this.hessenberg_clear(index);
        }
    }
}

