/*
 * Decompiled with CFR 0.152.
 */
package com.dreizak.miniball.model;

import com.dreizak.miniball.model.PointSet;

public final class ArrayPointSet
implements PointSet {
    private int d;
    private int n;
    private double[] c;

    public ArrayPointSet(int d, int n) {
        this.d = d;
        this.n = n;
        this.c = new double[n * d];
    }

    @Override
    public int size() {
        return this.n;
    }

    @Override
    public int dimension() {
        return this.d;
    }

    @Override
    public double coord(int i, int j) {
        assert (0 <= i && i < this.n);
        assert (0 <= j && j < this.d);
        return this.c[i * this.d + j];
    }

    public void set(int i, int j, double v) {
        assert (0 <= i && i < this.n);
        assert (0 <= j && j < this.d);
        this.c[i * this.d + j] = v;
    }

    public String toString() {
        StringBuffer s = new StringBuffer("{");
        for (int i = 0; i < this.n; ++i) {
            s.append('[');
            for (int j = 0; j < this.d; ++j) {
                s.append(this.coord(i, j));
                if (j >= this.d - 1) continue;
                s.append(",");
            }
            s.append(']');
            if (i >= this.n - 1) continue;
            s.append(", ");
        }
        s.append('}');
        return s.toString();
    }
}

