/*
 * Decompiled with CFR 0.152.
 */
package com.dreizak.miniball.model;

import com.dreizak.miniball.model.ArrayPointSet;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Scanner;

public class PointSetUtils {
    public static ArrayPointSet randomPointSet(int d, int n, Random r) {
        ArrayPointSet pts = new ArrayPointSet(d, n);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < d; ++j) {
                pts.set(i, j, r.nextDouble());
            }
        }
        return pts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final ArrayPointSet pointsFromStream(InputStream s) {
        ArrayPointSet arrayPointSet;
        InputStreamReader r = new InputStreamReader((InputStream)new BufferedInputStream(s), "UTF-8");
        Scanner in = new Scanner(r);
        try {
            int n = in.nextInt();
            int d = in.nextInt();
            ArrayPointSet pts = new ArrayPointSet(d, n);
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < d; ++j) {
                    pts.set(i, j, in.nextDouble());
                }
            }
            arrayPointSet = pts;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)r).close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not read points.", e);
                }
                throw throwable;
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Unkown encoding.", e);
            }
        }
        try {
            ((Reader)r).close();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read points.", e);
        }
        return arrayPointSet;
    }

    public static interface Random {
        public double nextDouble();
    }
}

