/*
 * Decompiled with CFR 0.152.
 */
package jsat.classifiers.evaluation;

import java.util.Arrays;
import jsat.classifiers.CategoricalData;
import jsat.classifiers.CategoricalResults;
import jsat.classifiers.evaluation.ClassificationScore;

public class LogLoss
implements ClassificationScore {
    private static final long serialVersionUID = 3123851772991293430L;
    private double loss;
    private double weightSum;
    private double nudge;

    public LogLoss() {
        this(1.0E-15);
    }

    public LogLoss(double nudge) {
        if (nudge < 0.0 || nudge >= 0.1) {
            throw new IllegalArgumentException("nudge must be a small non-negative value in [0, 0.1) not " + nudge);
        }
        this.nudge = nudge;
    }

    public LogLoss(LogLoss toClone) {
        this.loss = toClone.loss;
        this.weightSum = toClone.weightSum;
        this.nudge = toClone.nudge;
    }

    @Override
    public void addResult(CategoricalResults prediction, int trueLabel, double weight) {
        this.loss += weight * Math.log(Math.max(prediction.getProb(trueLabel), this.nudge));
        this.weightSum += weight;
    }

    @Override
    public void addResults(ClassificationScore other) {
        LogLoss otherObj = (LogLoss)other;
        this.loss += otherObj.loss;
        this.weightSum += otherObj.weightSum;
    }

    @Override
    public void prepare(CategoricalData toPredict) {
        this.loss = 0.0;
        this.weightSum = 0.0;
    }

    @Override
    public double getScore() {
        return -this.loss / this.weightSum;
    }

    @Override
    public boolean equals(Object obj) {
        if (this.getClass().isAssignableFrom(obj.getClass()) && obj.getClass().isAssignableFrom(this.getClass())) {
            return ((LogLoss)obj).nudge == this.nudge;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(new double[]{this.nudge});
    }

    @Override
    public boolean lowerIsBetter() {
        return true;
    }

    @Override
    public LogLoss clone() {
        return new LogLoss(this);
    }

    @Override
    public String getName() {
        return "Log Loss";
    }
}

