/*
 * Decompiled with CFR 0.152.
 */
package jsat.classifiers.linear;

import java.util.List;
import jsat.DataSet;
import jsat.SingleWeightVectorModel;
import jsat.classifiers.BaseUpdateableClassifier;
import jsat.classifiers.CategoricalData;
import jsat.classifiers.CategoricalResults;
import jsat.classifiers.DataPoint;
import jsat.classifiers.calibration.BinaryScoreClassifier;
import jsat.distributions.Distribution;
import jsat.distributions.LogUniform;
import jsat.exceptions.FailedToFitException;
import jsat.exceptions.UntrainedModelException;
import jsat.linear.DenseVector;
import jsat.linear.IndexValue;
import jsat.linear.Matrix;
import jsat.linear.Vec;
import jsat.parameters.Parameter;
import jsat.parameters.Parameterized;

public class AROW
extends BaseUpdateableClassifier
implements BinaryScoreClassifier,
Parameterized,
SingleWeightVectorModel {
    private static final long serialVersionUID = 443803827811508204L;
    private Vec w;
    private Matrix sigmaM;
    private Vec sigmaV;
    private boolean diagonalOnly = false;
    private double r;
    private Vec Sigma_xt;

    public AROW() {
        this(0.01, true);
    }

    public AROW(double r, boolean diagonalOnly) {
        this.setR(r);
        this.setDiagonalOnly(diagonalOnly);
    }

    protected AROW(AROW other) {
        this.r = other.r;
        this.diagonalOnly = other.diagonalOnly;
        if (other.w != null) {
            this.w = other.w.clone();
        }
        if (other.sigmaM != null) {
            this.sigmaM = other.sigmaM.clone();
        }
        if (other.sigmaV != null) {
            this.sigmaV = other.sigmaV.clone();
        }
        if (other.Sigma_xt != null) {
            this.Sigma_xt = other.Sigma_xt.clone();
        }
    }

    public void setDiagonalOnly(boolean diagonalOnly) {
        this.diagonalOnly = diagonalOnly;
    }

    public boolean isDiagonalOnly() {
        return this.diagonalOnly;
    }

    public void setR(double r) {
        if (Double.isNaN(r) || Double.isInfinite(r) || r <= 0.0) {
            throw new IllegalArgumentException("r must be a postive constant, not " + r);
        }
        this.r = r;
    }

    public double getR() {
        return this.r;
    }

    public Vec getWeightVec() {
        return this.w;
    }

    @Override
    public AROW clone() {
        return new AROW(this);
    }

    @Override
    public void setUp(CategoricalData[] categoricalAttributes, int numericAttributes, CategoricalData predicting) {
        if (numericAttributes <= 0) {
            throw new FailedToFitException("AROW requires numeric attributes to perform classification");
        }
        if (predicting.getNumOfCategories() != 2) {
            throw new FailedToFitException("AROW is a binary classifier");
        }
        this.w = new DenseVector(numericAttributes);
        this.Sigma_xt = new DenseVector(numericAttributes);
        if (this.diagonalOnly) {
            this.sigmaV = new DenseVector(numericAttributes);
            this.sigmaV.mutableAdd(1.0);
        } else {
            this.sigmaM = Matrix.eye(numericAttributes);
        }
    }

    @Override
    public void update(DataPoint dataPoint, int targetClass) {
        double y_t = targetClass * 2 - 1;
        Vec x_t = dataPoint.getNumericalValues();
        double m_t = x_t.dot(this.w);
        if (y_t == Math.signum(m_t)) {
            return;
        }
        double v_t = 0.0;
        if (this.diagonalOnly) {
            for (IndexValue iv : x_t) {
                double x_ti = iv.getValue();
                v_t += x_ti * x_ti * this.sigmaV.get(iv.getIndex());
            }
        } else {
            this.sigmaM.multiply(x_t, 1.0, this.Sigma_xt);
            v_t = x_t.dot(this.Sigma_xt);
        }
        double b_t_inv = v_t + this.r;
        double alpha_t = Math.max(0.0, 1.0 - y_t * m_t) / b_t_inv;
        if (!this.diagonalOnly) {
            this.w.mutableAdd(alpha_t * y_t, this.Sigma_xt);
        } else {
            for (IndexValue iv : x_t) {
                this.w.increment(iv.getIndex(), alpha_t * y_t * iv.getValue() * this.sigmaV.get(iv.getIndex()));
            }
        }
        if (this.diagonalOnly) {
            for (IndexValue iv : x_t) {
                int idx = iv.getIndex();
                double xt_i = iv.getValue() * this.sigmaV.get(idx);
                this.sigmaV.increment(idx, -(xt_i * xt_i) / b_t_inv);
            }
        } else {
            Matrix.OuterProductUpdate(this.sigmaM, this.Sigma_xt, this.Sigma_xt, -1.0 / b_t_inv);
        }
        if (this.diagonalOnly) {
            this.Sigma_xt.zeroOut();
        }
    }

    @Override
    public CategoricalResults classify(DataPoint data) {
        if (this.w == null) {
            throw new UntrainedModelException("Model has not yet ben trained");
        }
        CategoricalResults cr = new CategoricalResults(2);
        double score = this.getScore(data);
        if (score < 0.0) {
            cr.setProb(0, 1.0);
        } else {
            cr.setProb(1, 1.0);
        }
        return cr;
    }

    @Override
    public double getScore(DataPoint dp) {
        return this.w.dot(dp.getNumericalValues());
    }

    @Override
    public boolean supportsWeightedData() {
        return false;
    }

    @Override
    public List<Parameter> getParameters() {
        return Parameter.getParamsFromMethods(this);
    }

    @Override
    public Parameter getParameter(String paramName) {
        return Parameter.toParameterMap(this.getParameters()).get(paramName);
    }

    @Override
    public Vec getRawWeight() {
        return this.w;
    }

    @Override
    public double getBias() {
        return 0.0;
    }

    @Override
    public Vec getRawWeight(int index) {
        if (index < 1) {
            return this.getRawWeight();
        }
        throw new IndexOutOfBoundsException("Model has only 1 weight vector");
    }

    @Override
    public double getBias(int index) {
        if (index < 1) {
            return this.getBias();
        }
        throw new IndexOutOfBoundsException("Model has only 1 weight vector");
    }

    @Override
    public int numWeightsVecs() {
        return 1;
    }

    public static Distribution guessR(DataSet d) {
        return new LogUniform(Math.pow(2.0, -4.0), Math.pow(2.0, 4.0));
    }
}

