/*
 * Decompiled with CFR 0.152.
 */
package jsat.classifiers.trees;

import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import jsat.classifiers.DataPointPair;
import jsat.classifiers.trees.DecisionTree;
import jsat.classifiers.trees.TreePruner;
import jsat.utils.ModifiableCountDownLatch;

public class RandomDecisionTree
extends DecisionTree {
    private static final long serialVersionUID = -809244056947507494L;
    private int numFeatures;

    public RandomDecisionTree() {
        this(1);
    }

    public RandomDecisionTree(int numFeatures) {
        this.setRandomFeatureCount(numFeatures);
    }

    public RandomDecisionTree(int numFeatures, int maxDepth, int minSamples, TreePruner.PruningMethod pruningMethod, double testProportion) {
        super(maxDepth, minSamples, pruningMethod, testProportion);
        this.setRandomFeatureCount(numFeatures);
    }

    public RandomDecisionTree(RandomDecisionTree toCopy) {
        super(toCopy);
        this.numFeatures = toCopy.numFeatures;
    }

    public void setRandomFeatureCount(int numFeatures) {
        if (numFeatures < 1) {
            throw new IllegalArgumentException("Number of features must be positive, not " + numFeatures);
        }
        this.numFeatures = numFeatures;
    }

    public int getRandomFeatureCount() {
        return this.numFeatures;
    }

    @Override
    protected DecisionTree.Node makeNodeC(List<DataPointPair<Integer>> dataPoints, Set<Integer> options, int depth, ExecutorService threadPool, ModifiableCountDownLatch mcdl) {
        if (dataPoints.isEmpty()) {
            mcdl.countDown();
            return null;
        }
        int featureCount = dataPoints.get(0).getDataPoint().numCategoricalValues() + dataPoints.get(0).getDataPoint().numNumericalValues();
        this.fillWithRandomFeatures(options, featureCount);
        return super.makeNodeC(dataPoints, options, depth, threadPool, mcdl);
    }

    @Override
    protected DecisionTree.Node makeNodeR(List<DataPointPair<Double>> dataPoints, Set<Integer> options, int depth, ExecutorService threadPool, ModifiableCountDownLatch mcdl) {
        if (dataPoints.isEmpty()) {
            mcdl.countDown();
            return null;
        }
        int featureCount = dataPoints.get(0).getDataPoint().numCategoricalValues() + dataPoints.get(0).getDataPoint().numNumericalValues();
        this.fillWithRandomFeatures(options, featureCount);
        return super.makeNodeR(dataPoints, options, depth, threadPool, mcdl);
    }

    private void fillWithRandomFeatures(Set<Integer> options, int featureCount) {
        options.clear();
        Random rand = new Random();
        while (options.size() < this.numFeatures) {
            options.add(rand.nextInt(featureCount));
        }
    }

    @Override
    public RandomDecisionTree clone() {
        return new RandomDecisionTree(this);
    }
}

