/*
 * Decompiled with CFR 0.152.
 */
package jsat.clustering;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import jsat.DataSet;
import jsat.clustering.ClusterFailureException;
import jsat.clustering.ClustererBase;
import jsat.linear.Vec;
import jsat.linear.VecPaired;
import jsat.linear.distancemetrics.DistanceMetric;
import jsat.linear.distancemetrics.EuclideanDistance;
import jsat.linear.vectorcollection.DefaultVectorCollectionFactory;
import jsat.linear.vectorcollection.VectorCollection;
import jsat.linear.vectorcollection.VectorCollectionFactory;
import jsat.linear.vectorcollection.VectorCollectionUtils;
import jsat.math.OnLineStatistics;
import jsat.parameters.Parameter;
import jsat.parameters.Parameterized;
import jsat.utils.IntList;
import jsat.utils.IntSet;

public class OPTICS
extends ClustererBase
implements Parameterized {
    private static final long serialVersionUID = -1093772096278544211L;
    private static final int NOISE = -1;
    private static double UNDEFINED = Double.POSITIVE_INFINITY;
    public static final double DEFAULT_XI = 0.005;
    public static final int DEFAULT_MIN_POINTS = 10;
    public static final ExtractionMethod DEFAULT_EXTRACTION_METHOD = ExtractionMethod.THRESHHOLD_FIXUP;
    private DistanceMetric dm;
    private VectorCollectionFactory<VecPaired<Vec, Integer>> vcf = new DefaultVectorCollectionFactory<VecPaired<Vec, Integer>>();
    private VectorCollection<VecPaired<Vec, Integer>> vc;
    private double radius = 1.0;
    private int minPts;
    private double[] core_distance;
    private double[] reach_d;
    private boolean[] processed;
    private Vec[] allVecs;
    private double xi;
    private double one_min_xi;
    private ExtractionMethod extractionMethod = DEFAULT_EXTRACTION_METHOD;
    private PriorityQueue<Integer> orderdSeeds;

    @Override
    public List<Parameter> getParameters() {
        return Parameter.getParamsFromMethods(this);
    }

    @Override
    public Parameter getParameter(String paramName) {
        return Parameter.toParameterMap(this.getParameters()).get(paramName);
    }

    @Override
    public OPTICS clone() {
        return new OPTICS(this);
    }

    public OPTICS() {
        this(10);
    }

    public OPTICS(int minPts) {
        this(new EuclideanDistance(), minPts);
    }

    public OPTICS(DistanceMetric dm, int minPts) {
        this(dm, minPts, 0.005);
    }

    public OPTICS(DistanceMetric dm, int minPts, double xi) {
        this.setDistanceMetric(dm);
        this.setMinPts(minPts);
        this.setXi(xi);
    }

    public OPTICS(OPTICS toCopy) {
        this.dm = toCopy.dm.clone();
        this.vc = toCopy.vc.clone();
        this.minPts = toCopy.minPts;
        if (toCopy.core_distance != null) {
            this.core_distance = Arrays.copyOf(toCopy.core_distance, toCopy.core_distance.length);
        }
        if (toCopy.reach_d != null) {
            this.reach_d = Arrays.copyOf(toCopy.reach_d, toCopy.reach_d.length);
        }
        if (toCopy.processed != null) {
            this.processed = Arrays.copyOf(toCopy.processed, toCopy.processed.length);
        }
        if (toCopy.allVecs != null) {
            this.allVecs = new Vec[toCopy.allVecs.length];
            for (int i = 0; i < toCopy.allVecs.length; ++i) {
                this.allVecs[i] = toCopy.allVecs[i].clone();
            }
        }
        this.xi = toCopy.xi;
        this.orderdSeeds = toCopy.orderdSeeds;
        this.radius = toCopy.radius;
    }

    public void setDistanceMetric(DistanceMetric dm) {
        this.dm = dm;
    }

    public DistanceMetric getDistanceMetric() {
        return this.dm;
    }

    public void setXi(double xi) {
        if (xi <= 0.0 || xi >= 1.0 || Double.isNaN(xi)) {
            throw new ArithmeticException("xi must be in the range (0, 1) not " + xi);
        }
        this.xi = xi;
        this.one_min_xi = 1.0 - xi;
    }

    public double getXi() {
        return this.xi;
    }

    public void setExtractionMethod(ExtractionMethod extractionMethod) {
        this.extractionMethod = extractionMethod;
    }

    public ExtractionMethod getExtractionMethod() {
        return this.extractionMethod;
    }

    public void setMinPts(int minPts) {
        this.minPts = minPts;
    }

    public int getMinPts() {
        return this.minPts;
    }

    public void setVCF(VectorCollectionFactory<VecPaired<Vec, Integer>> vcf) {
        this.vcf = vcf;
    }

    private int threshHoldFixExtractCluster(List<Integer> orderedFile, int[] designations) {
        int clustersFound = this.threshHoldExtractCluster(orderedFile, designations);
        for (int i = 0; i < orderedFile.size(); ++i) {
            if (designations[i] != -1) continue;
            List<VecPaired<VecPaired<Vec, Integer>, Double>> neighbors = this.vc.search(this.allVecs[i], this.minPts / 2 + 1);
            int CLASS = -1;
            for (VecPaired<VecPaired<Vec, Integer>, Double> v : neighbors) {
                int subC = designations[v.getVector().getPair()];
                if (subC == -1) continue;
                if (CLASS == -1) {
                    CLASS = subC;
                    continue;
                }
                if (CLASS == subC) continue;
                CLASS = -2;
            }
            if (CLASS == -2) continue;
            designations[i] = CLASS;
        }
        return clustersFound;
    }

    private int threshHoldExtractCluster(List<Integer> orderedFile, int[] designations) {
        int clustersFound = 0;
        OnLineStatistics stats = new OnLineStatistics();
        for (double r : this.reach_d) {
            if (Double.isInfinite(r)) continue;
            stats.add(r);
        }
        double thresh = stats.getMean() + stats.getStandardDeviation();
        for (int i = 0; i < orderedFile.size(); ++i) {
            if (this.reach_d[orderedFile.get(i)] >= thresh) continue;
            while (i < orderedFile.size() && this.reach_d[orderedFile.get(i)] < thresh) {
                designations[i++] = clustersFound;
            }
            while (i + 1 < orderedFile.size() && this.reach_d[orderedFile.get(i)] < this.reach_d[orderedFile.get(i + 1)]) {
                designations[i++] = clustersFound;
            }
            ++clustersFound;
        }
        return clustersFound;
    }

    private int xiSteepClusterExtract(int n, List<Integer> orderedFile, int[] designations) {
        int clustersFound = 0;
        IntSet sdaSet = new IntSet();
        int orderIndex = 0;
        double mib = 0.0;
        double[] mibVals = new double[n];
        ArrayList<OPTICSCluster> clusters = new ArrayList<OPTICSCluster>();
        IntList allSteepUp = new IntList();
        IntList allSDA = new IntList();
        while (orderIndex < orderedFile.size() - 1) {
            int curIndex = orderedFile.get(orderIndex);
            mib = Math.max(mib, this.reach_d[curIndex]);
            if (orderIndex + 1 < orderedFile.size()) {
                int nextIndex = orderedFile.get(orderIndex + 1);
                if (!this.downPoint(curIndex, nextIndex)) {
                    this.filterSDASet(sdaSet, mib, mibVals, orderedFile);
                    sdaSet.add(orderIndex);
                    allSDA.add(Integer.valueOf(orderIndex));
                    while (orderIndex + 1 < orderedFile.size()) {
                        curIndex = nextIndex;
                        if (++orderIndex + 1 < orderedFile.size() && !this.downPoint(curIndex, nextIndex = orderedFile.get(orderIndex + 1).intValue())) continue;
                    }
                    mib = this.reach_d[curIndex];
                    continue;
                }
                if (!this.upPoint(curIndex, nextIndex)) {
                    this.filterSDASet(sdaSet, mib, mibVals, orderedFile);
                    if (!sdaSet.isEmpty()) {
                        allSteepUp.add(Integer.valueOf(orderIndex));
                    }
                    while (orderIndex + 1 < orderedFile.size()) {
                        curIndex = nextIndex;
                        if (++orderIndex + 1 < orderedFile.size() && !this.upPoint(curIndex, nextIndex = orderedFile.get(orderIndex + 1).intValue())) continue;
                    }
                    mib = this.reach_d[curIndex];
                    Iterator iter = sdaSet.iterator();
                    while (iter.hasNext()) {
                        int sdaOrdered = (Integer)iter.next();
                        int sdaIndx = orderedFile.get(sdaOrdered);
                        if (orderIndex - sdaOrdered < this.minPts || mib * this.one_min_xi < mibVals[sdaIndx] || sdaOrdered > orderIndex) continue;
                        OPTICSCluster newClust = new OPTICSCluster(sdaOrdered, orderIndex + 1);
                        Iterator clustIter = clusters.iterator();
                        while (clustIter.hasNext()) {
                            OPTICSCluster tmp = (OPTICSCluster)clustIter.next();
                            if (!newClust.contains(tmp)) continue;
                            clustIter.remove();
                            newClust.subClusters.add(tmp);
                        }
                        clusters.add(newClust);
                    }
                    continue;
                }
                ++orderIndex;
                continue;
            }
            ++orderIndex;
        }
        for (OPTICSCluster oc : clusters) {
            for (int i : orderedFile.subList(oc.start, oc.end)) {
                if (designations[i] >= 0) continue;
                designations[i] = clustersFound;
            }
            ++clustersFound;
        }
        return clustersFound;
    }

    @Override
    public int[] cluster(DataSet dataSet, int[] designations) {
        int clustersFound;
        if (dataSet.getNumNumericalVars() < 1) {
            throw new ClusterFailureException("OPTICS requires numeric features, and non are present.");
        }
        int n = dataSet.getSampleSize();
        if (designations == null) {
            designations = new int[n];
        }
        Arrays.fill(designations, -1);
        this.orderdSeeds = new PriorityQueue<Integer>(n, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return Double.compare(OPTICS.this.reach_d[o1], OPTICS.this.reach_d[o2]);
            }
        });
        this.core_distance = new double[n];
        this.reach_d = new double[n];
        Arrays.fill(this.reach_d, UNDEFINED);
        this.processed = new boolean[n];
        this.allVecs = new Vec[n];
        ArrayList<VecPaired<Vec, Integer>> pairedVecs = new ArrayList<VecPaired<Vec, Integer>>(n);
        for (int i = 0; i < this.allVecs.length; ++i) {
            this.allVecs[i] = dataSet.getDataPoint(i).getNumericalValues();
            pairedVecs.add(new VecPaired<Vec, Integer>(this.allVecs[i], i));
        }
        this.vc = this.vcf.getVectorCollection(pairedVecs, this.dm);
        OnLineStatistics stats = VectorCollectionUtils.getKthNeighborStats(this.vc, (Vec[])this.allVecs, (int)(this.minPts + 1));
        this.radius = stats.getMean() + stats.getStandardDeviation() * 3.0;
        IntList orderedFile = new IntList(n);
        for (int i = 0; i < dataSet.getSampleSize(); ++i) {
            if (this.processed[i]) continue;
            Vec vec = dataSet.getDataPoint(i).getNumericalValues();
            this.expandClusterOrder(i, vec, orderedFile);
        }
        if (this.extractionMethod == ExtractionMethod.THRESHHOLD) {
            clustersFound = this.threshHoldExtractCluster(orderedFile, designations);
        } else if (this.extractionMethod == ExtractionMethod.THRESHHOLD_FIXUP) {
            clustersFound = this.threshHoldFixExtractCluster(orderedFile, designations);
        } else if (this.extractionMethod == ExtractionMethod.XI_STEEP_ORIGINAL) {
            int n2 = this.xiSteepClusterExtract(n, orderedFile, designations);
        }
        double[] newReach = new double[this.reach_d.length];
        Arrays.fill(newReach, Double.POSITIVE_INFINITY);
        for (int i = 0; i < orderedFile.size(); ++i) {
            newReach[i] = this.reach_d[(Integer)orderedFile.get(i)];
        }
        this.reach_d = newReach;
        return designations;
    }

    private void filterSDASet(Set<Integer> sdaSet, double mib, double[] mibVals, List<Integer> orderedFile) {
        Iterator<Integer> iter = sdaSet.iterator();
        while (iter.hasNext()) {
            int sdaIndx = orderedFile.get(iter.next());
            if (this.reach_d[sdaIndx] * this.one_min_xi <= mib) {
                iter.remove();
                continue;
            }
            mibVals[sdaIndx] = Math.max(mib, mibVals[sdaIndx]);
        }
    }

    private boolean upPoint(int index1, int index2) {
        return this.reach_d[index1] <= this.reach_d[index2] * this.one_min_xi;
    }

    private boolean downPoint(int index1, int index2) {
        return this.reach_d[index1] * this.one_min_xi <= this.reach_d[index2];
    }

    @Override
    public int[] cluster(DataSet dataSet, ExecutorService threadpool, int[] designations) {
        return this.cluster(dataSet, designations);
    }

    private void expandClusterOrder(int curIndex, Vec vec, List<Integer> orderedFile) {
        List<VecPaired<VecPaired<Vec, Integer>, Double>> neighbors = this.vc.search(vec, this.radius);
        VecPaired<Vec, Integer> object = new VecPaired<Vec, Integer>(vec, curIndex);
        this.reach_d[curIndex] = UNDEFINED;
        this.processed[curIndex] = true;
        this.setCoreDistance(neighbors, curIndex);
        orderedFile.add(curIndex);
        if (!Double.isInfinite(this.core_distance[curIndex])) {
            this.orderedSeedsUpdate(neighbors, curIndex);
            while (!this.orderdSeeds.isEmpty()) {
                int curObjectIndex = this.orderdSeeds.poll();
                neighbors = this.vc.search(this.allVecs[curObjectIndex], this.radius);
                this.processed[curObjectIndex] = true;
                this.setCoreDistance(neighbors, curObjectIndex);
                orderedFile.add(curObjectIndex);
                if (Double.isInfinite(this.core_distance[curObjectIndex])) continue;
                this.orderedSeedsUpdate(neighbors, curObjectIndex);
            }
        }
    }

    private void setCoreDistance(List<? extends VecPaired<VecPaired<Vec, Integer>, Double>> neighbors, int curIndex) {
        this.core_distance[curIndex] = neighbors.size() < this.minPts + 1 ? UNDEFINED : neighbors.get(this.minPts).getPair();
    }

    private void orderedSeedsUpdate(List<? extends VecPaired<VecPaired<Vec, Integer>, Double>> neighbors, int centerObjectIndex) {
        double c_dist = this.core_distance[centerObjectIndex];
        for (int i = 1; i < neighbors.size(); ++i) {
            VecPaired<VecPaired<Vec, Integer>, Double> neighbor = neighbors.get(i);
            int objIndex = neighbor.getVector().getPair();
            if (this.processed[objIndex]) continue;
            double new_r_dist = Math.max(c_dist, neighbor.getPair());
            if (Double.isInfinite(this.reach_d[objIndex])) {
                this.reach_d[objIndex] = new_r_dist;
                this.orderdSeeds.add(objIndex);
                continue;
            }
            if (!(new_r_dist < this.reach_d[objIndex])) continue;
            this.reach_d[objIndex] = new_r_dist;
            this.orderdSeeds.remove(objIndex);
            this.orderdSeeds.add(objIndex);
        }
    }

    private void extractClusteringDBSCAN(List<Integer> orderedFile, double e, int[] designations) {
        int clusterID = -1;
        for (int i = 0; i < orderedFile.size(); ++i) {
            int trueObjIndex = orderedFile.get(i);
            if (Double.isInfinite(this.reach_d[trueObjIndex]) || this.reach_d[trueObjIndex] > e) {
                if (this.core_distance[trueObjIndex] <= e) {
                    designations[trueObjIndex] = ++clusterID;
                    continue;
                }
                designations[trueObjIndex] = -1;
                continue;
            }
            designations[trueObjIndex] = clusterID;
        }
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public double[] getReachabilityArray() {
        return Arrays.copyOf(this.reach_d, this.reach_d.length);
    }

    private class OPTICSCluster {
        int start;
        int end;
        List<OPTICSCluster> subClusters;

        public OPTICSCluster(int start, int end) {
            this.start = start;
            this.end = end;
            this.subClusters = new ArrayList<OPTICSCluster>(5);
        }

        public boolean contains(OPTICSCluster other) {
            return this.start <= other.start && other.end <= this.end;
        }

        public String toString() {
            return "{" + this.start + "," + this.end + "}";
        }
    }

    public static enum ExtractionMethod {
        XI_STEEP_ORIGINAL,
        THRESHHOLD,
        THRESHHOLD_FIXUP;

    }
}

