/*
 * Decompiled with CFR 0.152.
 */
package jsat.clustering.evaluation.intra;

import java.util.List;
import jsat.DataSet;
import jsat.classifiers.DataPoint;
import jsat.clustering.evaluation.intra.IntraClusterEvaluation;
import jsat.linear.distancemetrics.DistanceMetric;
import jsat.linear.distancemetrics.EuclideanDistance;

public class MaxDistance
implements IntraClusterEvaluation {
    private DistanceMetric dm;

    public MaxDistance() {
        this(new EuclideanDistance());
    }

    public MaxDistance(DistanceMetric dm) {
        this.dm = dm;
    }

    public MaxDistance(MaxDistance toCopy) {
        this(toCopy.dm.clone());
    }

    @Override
    public double evaluate(int[] designations, DataSet dataSet, int clusterID) {
        double maxDistance = 0.0;
        for (int i = 0; i < dataSet.getSampleSize(); ++i) {
            for (int j = i + 1; j < dataSet.getSampleSize(); ++j) {
                if (designations[i] != clusterID) continue;
                maxDistance = Math.max(this.dm.dist(dataSet.getDataPoint(i).getNumericalValues(), dataSet.getDataPoint(j).getNumericalValues()), maxDistance);
            }
        }
        return maxDistance;
    }

    @Override
    public double evaluate(List<DataPoint> dataPoints) {
        double maxDistance = 0.0;
        for (int i = 0; i < dataPoints.size(); ++i) {
            for (int j = i + 1; j < dataPoints.size(); ++j) {
                maxDistance = Math.max(this.dm.dist(dataPoints.get(i).getNumericalValues(), dataPoints.get(j).getNumericalValues()), maxDistance);
            }
        }
        return maxDistance;
    }

    @Override
    public MaxDistance clone() {
        return new MaxDistance(this);
    }
}

