/*
 * Decompiled with CFR 0.152.
 */
package jsat.clustering.hierarchical;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import jsat.DataSet;
import jsat.clustering.KClustererBase;
import jsat.clustering.dissimilarity.AbstractClusterDissimilarity;
import jsat.clustering.dissimilarity.ClusterDissimilarity;
import jsat.math.OnLineStatistics;
import jsat.utils.IntSet;

public class SimpleHAC
extends KClustererBase {
    private static final long serialVersionUID = 7138073766768205530L;
    private double stndDevs = 3.5;
    private ClusterDissimilarity dissMeasure;

    public SimpleHAC(ClusterDissimilarity disMeasure) {
        this.dissMeasure = disMeasure;
    }

    public SimpleHAC(SimpleHAC toCopy) {
        this(toCopy.dissMeasure.clone());
        this.stndDevs = toCopy.stndDevs;
    }

    @Override
    public int[] cluster(DataSet dataSet, int[] designations) {
        return this.cluster(dataSet, 2, (int)Math.sqrt(dataSet.getSampleSize()), designations);
    }

    @Override
    public int[] cluster(DataSet dataSet, ExecutorService threadpool, int[] designations) {
        return this.cluster(dataSet, designations);
    }

    @Override
    public int[] cluster(DataSet dataSet, int clusters, ExecutorService threadpool, int[] designations) {
        return this.cluster(dataSet, clusters, designations);
    }

    @Override
    public int[] cluster(DataSet dataSet, int clusters, int[] designations) {
        return this.cluster(dataSet, clusters, clusters, designations);
    }

    @Override
    public int[] cluster(DataSet dataSet, int lowK, int highK, ExecutorService threadpool, int[] designations) {
        return this.cluster(dataSet, lowK, highK, designations);
    }

    @Override
    public int[] cluster(DataSet dataSet, int lowK, int highK, int[] designations) {
        if (designations == null) {
            designations = new int[dataSet.getSampleSize()];
        }
        OnLineStatistics disChange = new OnLineStatistics();
        ArrayList<IntSet> clusters = new ArrayList<IntSet>(dataSet.getSampleSize());
        for (int i = 0; i < dataSet.getSampleSize(); ++i) {
            IntSet set = new IntSet();
            set.add(i);
            clusters.add(set);
        }
        double[][] distanceMatrix = AbstractClusterDissimilarity.createDistanceMatrix(dataSet, this.dissMeasure);
        while (clusters.size() > lowK) {
            double lowestDiss = Double.MAX_VALUE;
            int a = 0;
            int b = 1;
            for (int i = 0; i < clusters.size(); ++i) {
                for (int j = i + 1; j < clusters.size(); ++j) {
                    double d;
                    double d2 = this.dissMeasure.dissimilarity((Set)clusters.get(i), (Set)clusters.get(j), distanceMatrix);
                    if (!(d < lowestDiss)) continue;
                    lowestDiss = d2;
                    a = i;
                    b = j;
                }
            }
            if (clusters.size() <= highK && disChange.getMean() + disChange.getStandardDeviation() * this.stndDevs < lowestDiss) break;
            disChange.add(lowestDiss);
            ((Set)clusters.get(a)).addAll((Collection)clusters.remove(b));
        }
        int curClusterID = 0;
        for (Set set : clusters) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                int index = (Integer)iterator.next();
                designations[index] = curClusterID;
            }
            ++curClusterID;
        }
        return designations;
    }

    @Override
    public SimpleHAC clone() {
        return new SimpleHAC(this);
    }
}

