/*
 * Decompiled with CFR 0.152.
 */
package jsat.clustering.kmeans;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import jsat.DataSet;
import jsat.clustering.kmeans.KernelKMeans;
import jsat.distributions.kernels.KernelTrick;
import jsat.exceptions.FailedToFitException;
import jsat.utils.SystemInfo;

public class LloydKernelKMeans
extends KernelKMeans {
    private static final long serialVersionUID = 1280985811243830450L;

    public LloydKernelKMeans(KernelTrick kernel) {
        super(kernel);
    }

    public LloydKernelKMeans(LloydKernelKMeans toCopy) {
        super(toCopy);
    }

    @Override
    public int[] cluster(DataSet dataSet, final int K, ExecutorService threadpool, int[] designations) {
        int changed;
        if (K < 2) {
            throw new FailedToFitException("Clustering requires at least 2 clusters");
        }
        final int N = dataSet.getSampleSize();
        if (designations == null) {
            designations = new int[N];
        }
        this.X = dataSet.getDataVectors();
        this.setup(K, designations, dataSet.getDataWeights());
        final int[] assignments = designations;
        int iter = 0;
        do {
            changed = 0;
            final CountDownLatch latch = new CountDownLatch(SystemInfo.LogicalCores);
            int id = 0;
            while (id < SystemInfo.LogicalCores) {
                final int ID = id++;
                threadpool.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = ID; i < N; i += SystemInfo.LogicalCores) {
                            double minDist = Double.POSITIVE_INFINITY;
                            int min_indx = 0;
                            for (int k = 0; k < K; ++k) {
                                double dist_k = LloydKernelKMeans.this.distance(i, k, assignments);
                                if (!(dist_k < minDist)) continue;
                                minDist = dist_k;
                                min_indx = k;
                            }
                            LloydKernelKMeans.this.newDesignations[i] = min_indx;
                        }
                        latch.countDown();
                    }
                });
            }
            try {
                latch.await();
            }
            catch (InterruptedException ex) {
                Logger.getLogger(LloydKernelKMeans.class.getName()).log(Level.SEVERE, null, ex);
            }
            ArrayList<Future<Integer>> futureChanges = new ArrayList<Future<Integer>>(SystemInfo.LogicalCores);
            int id2 = 0;
            while (id2 < SystemInfo.LogicalCores) {
                final int n = id2++;
                futureChanges.add(threadpool.submit(new Callable<Integer>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Integer call() throws Exception {
                        double[] sqrdChange = new double[K];
                        double[] ownerChange = new double[K];
                        int localChagne = 0;
                        for (int i = n; i < N; i += SystemInfo.LogicalCores) {
                            localChagne += LloydKernelKMeans.this.updateMeansFromChange(i, assignments, sqrdChange, ownerChange);
                        }
                        int[] nArray = assignments;
                        synchronized (assignments) {
                            LloydKernelKMeans.this.applyMeanUpdates(sqrdChange, ownerChange);
                            // ** MonitorExit[var4_5] (shouldn't be in output)
                            return localChagne;
                        }
                    }
                }));
            }
            try {
                for (Future future : futureChanges) {
                    changed += ((Integer)future.get()).intValue();
                }
            }
            catch (InterruptedException ex) {
                Logger.getLogger(LloydKernelKMeans.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(LloydKernelKMeans.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.updateNormConsts();
            System.arraycopy(this.newDesignations, 0, designations, 0, N);
        } while (changed > 0 && ++iter < this.maximumIterations);
        return designations;
    }

    @Override
    public int[] cluster(DataSet dataSet, int K, int[] designations) {
        int changed;
        if (K < 2) {
            throw new FailedToFitException("Clustering requires at least 2 clusters");
        }
        int N = dataSet.getSampleSize();
        if (designations == null) {
            designations = new int[N];
        }
        this.X = dataSet.getDataVectors();
        this.setup(K, designations, dataSet.getDataWeights());
        int iter = 0;
        do {
            int i;
            changed = 0;
            for (i = 0; i < N; ++i) {
                double minDist = Double.POSITIVE_INFINITY;
                int min_indx = 0;
                for (int k = 0; k < K; ++k) {
                    double dist_k = this.distance(i, k, designations);
                    if (!(dist_k < minDist)) continue;
                    minDist = dist_k;
                    min_indx = k;
                }
                this.newDesignations[i] = min_indx;
            }
            for (i = 0; i < N; ++i) {
                changed += this.updateMeansFromChange(i, designations);
            }
            this.updateNormConsts();
            System.arraycopy(this.newDesignations, 0, designations, 0, N);
        } while (changed > 0 && ++iter < this.maximumIterations);
        return designations;
    }

    @Override
    public KernelKMeans clone() {
        return new LloydKernelKMeans(this);
    }
}

