/*
 * Decompiled with CFR 0.152.
 */
package jsat.datatransform;

import java.util.Random;
import jsat.DataSet;
import jsat.classifiers.DataPoint;
import jsat.datatransform.InPlaceTransform;
import jsat.linear.Vec;
import jsat.utils.random.XORWOW;

public class InsertMissingValuesTransform
implements InPlaceTransform {
    private double prob;
    private Random rand;

    public InsertMissingValuesTransform(double prob) {
        this(prob, new XORWOW());
    }

    public InsertMissingValuesTransform(double prob, Random rand) {
        this.prob = Math.min(1.0, Math.max(0.0, prob));
        this.rand = rand;
    }

    @Override
    public void fit(DataSet data) {
    }

    @Override
    public void mutableTransform(DataPoint dp) {
        Vec v = dp.getNumericalValues();
        for (int i = 0; i < v.length(); ++i) {
            if (!(this.rand.nextDouble() < this.prob)) continue;
            v.set(i, Double.NaN);
        }
        int[] cats = dp.getCategoricalValues();
        for (int i = 0; i < cats.length; ++i) {
            if (!(this.rand.nextDouble() < this.prob)) continue;
            cats[i] = -1;
        }
    }

    @Override
    public boolean mutatesNominal() {
        return true;
    }

    @Override
    public DataPoint transform(DataPoint dp) {
        DataPoint ndp = dp.clone();
        this.mutableTransform(ndp);
        return ndp;
    }

    @Override
    public InsertMissingValuesTransform clone() {
        return new InsertMissingValuesTransform(this.prob, this.rand);
    }
}

