/*
 * Decompiled with CFR 0.152.
 */
package jsat.datatransform;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jsat.DataSet;
import jsat.classifiers.CategoricalData;
import jsat.classifiers.DataPoint;
import jsat.datatransform.DataTransform;
import jsat.linear.DenseVector;
import jsat.linear.IndexValue;
import jsat.linear.SparseVector;
import jsat.linear.Vec;
import jsat.utils.IntList;

public class RemoveAttributeTransform
implements DataTransform {
    private static final long serialVersionUID = 2803223213862922734L;
    protected int[] catIndexMap;
    protected int[] numIndexMap;
    private Set<Integer> categoricalToRemove;
    private Set<Integer> numericalToRemove;

    protected RemoveAttributeTransform() {
    }

    public RemoveAttributeTransform(Set<Integer> categoricalToRemove, Set<Integer> numericalToRemove) {
        this.categoricalToRemove = categoricalToRemove;
        this.numericalToRemove = numericalToRemove;
    }

    public RemoveAttributeTransform(DataSet dataSet, Set<Integer> categoricalToRemove, Set<Integer> numericalToRemove) {
        this.categoricalToRemove = categoricalToRemove;
        this.numericalToRemove = numericalToRemove;
        this.setUp(dataSet, categoricalToRemove, numericalToRemove);
    }

    public List<Integer> getKeptNumeric() {
        return IntList.unmodifiableView(this.numIndexMap, this.numIndexMap.length);
    }

    public Map<Integer, Integer> getReverseNumericMap() {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        for (int newIndex = 0; newIndex < this.numIndexMap.length; ++newIndex) {
            map.put(newIndex, this.numIndexMap[newIndex]);
        }
        return map;
    }

    public List<Integer> getKeptNominal() {
        return IntList.unmodifiableView(this.catIndexMap, this.catIndexMap.length);
    }

    public Map<Integer, Integer> getReverseNominalMap() {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        for (int newIndex = 0; newIndex < this.catIndexMap.length; ++newIndex) {
            map.put(newIndex, this.catIndexMap[newIndex]);
        }
        return map;
    }

    @Override
    public void fit(DataSet data) {
        if (this.categoricalToRemove != null && this.numericalToRemove != null) {
            this.setUp(data, this.categoricalToRemove, this.numericalToRemove);
        }
    }

    protected final void setUp(DataSet dataSet, Set<Integer> categoricalToRemove, Set<Integer> numericalToRemove) {
        int i2;
        for (int i2 : categoricalToRemove) {
            if (i2 < dataSet.getNumCategoricalVars()) continue;
            throw new RuntimeException("The data set does not have a categorical value " + i2 + " to remove");
        }
        for (int i2 : numericalToRemove) {
            if (i2 < dataSet.getNumNumericalVars()) continue;
            throw new RuntimeException("The data set does not have a numercal value " + i2 + " to remove");
        }
        this.catIndexMap = new int[dataSet.getNumCategoricalVars() - categoricalToRemove.size()];
        this.numIndexMap = new int[dataSet.getNumNumericalVars() - numericalToRemove.size()];
        int k = 0;
        for (i2 = 0; i2 < dataSet.getNumCategoricalVars(); ++i2) {
            if (categoricalToRemove.contains(i2)) continue;
            this.catIndexMap[k++] = i2;
        }
        k = 0;
        for (i2 = 0; i2 < dataSet.getNumNumericalVars(); ++i2) {
            if (numericalToRemove.contains(i2)) continue;
            this.numIndexMap[k++] = i2;
        }
    }

    protected RemoveAttributeTransform(RemoveAttributeTransform other) {
        if (other.catIndexMap != null) {
            this.catIndexMap = Arrays.copyOf(other.catIndexMap, other.catIndexMap.length);
        }
        if (other.numIndexMap != null) {
            this.numIndexMap = Arrays.copyOf(other.numIndexMap, other.numIndexMap.length);
        }
    }

    public void consolidate(RemoveAttributeTransform preceding) {
        int i;
        for (i = 0; i < this.catIndexMap.length; ++i) {
            this.catIndexMap[i] = preceding.catIndexMap[this.catIndexMap[i]];
        }
        for (i = 0; i < this.numIndexMap.length; ++i) {
            this.numIndexMap[i] = preceding.numIndexMap[this.numIndexMap[i]];
        }
    }

    @Override
    public DataPoint transform(DataPoint dp) {
        int[] catVals = dp.getCategoricalValues();
        Vec numVals = dp.getNumericalValues();
        CategoricalData[] newCatData = new CategoricalData[this.catIndexMap.length];
        int[] newCatVals = new int[newCatData.length];
        Vec newNumVals = numVals.isSparse() ? (numVals instanceof SparseVector ? new SparseVector(this.numIndexMap.length, ((SparseVector)numVals).nnz()) : new SparseVector(this.numIndexMap.length)) : new DenseVector(this.numIndexMap.length);
        for (int i = 0; i < this.catIndexMap.length; ++i) {
            newCatVals[i] = catVals[this.catIndexMap[i]];
        }
        boolean k = false;
        Iterator<IndexValue> iter = numVals.getNonZeroIterator();
        if (iter.hasNext()) {
            IndexValue curIV = iter.next();
            for (int i = 0; i < this.numIndexMap.length; ++i) {
                if (numVals.isSparse()) {
                    if (curIV == null) continue;
                    if (this.numIndexMap[i] > curIV.getIndex()) {
                        while (this.numIndexMap[i] > curIV.getIndex() && iter.hasNext()) {
                            curIV = iter.next();
                        }
                    }
                    if (this.numIndexMap[i] < curIV.getIndex() || this.numIndexMap[i] != curIV.getIndex()) continue;
                    newNumVals.set(i, curIV.getValue());
                    if (iter.hasNext()) {
                        curIV = iter.next();
                        continue;
                    }
                    curIV = null;
                    continue;
                }
                newNumVals.set(i, numVals.get(this.numIndexMap[i]));
            }
        }
        return new DataPoint(newNumVals, newCatVals, newCatData, dp.getWeight());
    }

    @Override
    public RemoveAttributeTransform clone() {
        return new RemoveAttributeTransform(this);
    }
}

