/*
 * Decompiled with CFR 0.152.
 */
package jsat.distributions;

import jsat.distributions.ContinuousDistribution;
import jsat.linear.Vec;
import jsat.math.Function;
import jsat.math.rootfinding.RiddersMethod;

public class Kolmogorov
extends ContinuousDistribution {
    private static final long serialVersionUID = 7319511918364286930L;
    private final Function fCDF = new Function(){
        private static final long serialVersionUID = -716553015542184045L;

        @Override
        public double f(double ... x) {
            return Kolmogorov.this.cdf(x[0]) - x[1];
        }

        @Override
        public double f(Vec x) {
            return this.f(x.get(0), x.get(1));
        }
    };

    @Override
    public double pdf(double x) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double cdf(double x) {
        if (x < 0.0) {
            throw new ArithmeticException("Invalid value of x, x must be > 0, not " + x);
        }
        if (x == 0.0) {
            return 0.0;
        }
        if (x >= 5.0) {
            return 1.0;
        }
        double tmp = 0.0;
        double x2 = x * x;
        if (x < 1.18) {
            for (int j = 1; j <= 3; ++j) {
                tmp += Math.exp(-Math.pow(2 * j - 1, 2.0) * Math.PI * Math.PI / (8.0 * x2));
            }
            return Math.sqrt(Math.PI * 2) / x * tmp;
        }
        tmp = Math.exp(-2.0 * x2) + Math.exp(-18.0 * x2) - Math.exp(-8.0 * x2);
        return 1.0 - 2.0 * tmp;
    }

    @Override
    public double invCdf(double p) {
        return RiddersMethod.root(0.0, 5.0, this.fCDF, p, p);
    }

    @Override
    public double min() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double max() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getDistributionName() {
        return "Kolmogorov";
    }

    @Override
    public String[] getVariables() {
        return new String[0];
    }

    @Override
    public double[] getCurrentVariableValues() {
        return new double[0];
    }

    @Override
    public void setVariable(String var, double value) {
    }

    @Override
    public ContinuousDistribution clone() {
        return new Kolmogorov();
    }

    @Override
    public void setUsingData(Vec data) {
    }

    @Override
    public double mean() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double median() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double mode() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double variance() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double skewness() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int hashCode() {
        return 31;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }
}

