/*
 * Decompiled with CFR 0.152.
 */
package jsat.distributions;

import jsat.distributions.ContinuousDistribution;
import jsat.linear.Vec;

public final class Laplace
extends ContinuousDistribution {
    private static final long serialVersionUID = -4799360517803678236L;
    private double mu;
    private double b;

    public Laplace(double mu, double b) {
        this.setB(b);
        this.setMu(mu);
    }

    public void setMu(double mu) {
        this.mu = mu;
    }

    public double getMu() {
        return this.mu;
    }

    public void setB(double b) {
        if (b <= 0.0) {
            throw new ArithmeticException("The scale parameter must be > 0");
        }
        this.b = b;
    }

    public double getB() {
        return this.b;
    }

    @Override
    public double pdf(double x) {
        return 1.0 / (2.0 * this.b) * Math.exp(-Math.abs(x - this.mu) / this.b);
    }

    @Override
    public double cdf(double x) {
        double xMu = x - this.mu;
        return 0.5 * (1.0 + Math.signum(x) * (1.0 - Math.exp(-Math.abs(xMu) / this.b)));
    }

    @Override
    public double invCdf(double p) {
        return this.mu - this.b * Math.signum(p - 0.5) * Math.log(1.0 - 2.0 * Math.abs(p - 0.5));
    }

    @Override
    public double min() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public double max() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public String getDistributionName() {
        return "Laplace";
    }

    @Override
    public String[] getVariables() {
        return new String[]{"\u03bc", "b"};
    }

    @Override
    public double[] getCurrentVariableValues() {
        return new double[]{this.mu, this.b};
    }

    @Override
    public void setVariable(String var, double value) {
        if (var.equals("\u03bc")) {
            this.setMu(value);
        } else if (var.equals("b")) {
            this.setB(value);
        }
    }

    @Override
    public ContinuousDistribution clone() {
        return new Laplace(this.mu, this.b);
    }

    @Override
    public void setUsingData(Vec data) {
        double tmpMu = data.mean();
        double newB = 0.0;
        for (int i = 0; i < data.length(); ++i) {
            newB += Math.abs(data.get(i) - tmpMu);
        }
        this.setB(newB /= (double)data.length());
        this.setMu(tmpMu);
    }

    @Override
    public double mean() {
        return this.mu;
    }

    @Override
    public double median() {
        return this.mu;
    }

    @Override
    public double mode() {
        return this.mu;
    }

    @Override
    public double variance() {
        return 2.0 * this.b * this.b;
    }

    @Override
    public double skewness() {
        return 0.0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.b);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.mu);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Laplace other = (Laplace)obj;
        if (Double.doubleToLongBits(this.b) != Double.doubleToLongBits(other.b)) {
            return false;
        }
        return Double.doubleToLongBits(this.mu) == Double.doubleToLongBits(other.mu);
    }
}

