/*
 * Decompiled with CFR 0.152.
 */
package jsat.linear;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jsat.linear.DenseVector;
import jsat.linear.GenericMatrix;
import jsat.linear.Matrix;
import jsat.linear.SparseVector;
import jsat.linear.SubVector;
import jsat.linear.Vec;

public class MatrixOfVecs
extends GenericMatrix {
    private static final long serialVersionUID = 6120353195388663462L;
    private List<Vec> rows;

    public MatrixOfVecs(Vec ... rows) {
        this(Arrays.asList(rows));
    }

    public MatrixOfVecs(List<Vec> rows) {
        this.rows = new ArrayList<Vec>(rows);
        int cols = rows.get(0).length();
        for (Vec v : rows) {
            if (cols == v.length()) continue;
            throw new IllegalArgumentException("Row vectors must all be of the same length");
        }
    }

    public MatrixOfVecs(int rows, int cols, boolean sparse) {
        this.rows = new ArrayList<Vec>(rows);
        for (int i = 0; i < rows; ++i) {
            this.rows.add(sparse ? new SparseVector(cols) : new DenseVector(cols));
        }
    }

    @Override
    protected Matrix getMatrixOfSameType(int rows, int cols) {
        return new MatrixOfVecs(rows, cols, this.isSparce());
    }

    @Override
    public void changeSize(int newRows, int newCols) {
        if (newRows <= 0 || newCols <= 0) {
            throw new IllegalArgumentException("Rows and columns must be positive, new dimension of [" + newRows + "," + newCols + "] is invalid");
        }
        if (newCols != this.cols()) {
            for (int i = 0; i < this.rows(); ++i) {
                Vec newV;
                Vec orig = this.rows.get(i);
                Vec vec = newV = orig.isSparse() ? new SparseVector(newCols) : new DenseVector(newCols);
                if (newCols < orig.length()) {
                    new SubVector(0, newCols, orig).copyTo(newV);
                } else {
                    orig.copyTo(new SubVector(0, orig.length(), newV));
                }
                this.rows.set(i, newV);
            }
        }
        if (newRows < this.rows()) {
            this.rows.subList(newRows, this.rows()).clear();
        } else if (newRows > this.rows()) {
            while (this.rows.size() < newRows) {
                Vec newV = this.rows.get(this.rows.size() - 1).clone();
                newV.zeroOut();
                this.rows.add(newV);
            }
        }
    }

    @Override
    public double get(int i, int j) {
        if (i >= this.rows() || i < 0) {
            throw new IndexOutOfBoundsException("row " + i + " is not a valid index");
        }
        if (j >= this.cols() || j < 0) {
            throw new IndexOutOfBoundsException("column " + j + " is not a valid index");
        }
        return this.rows.get(i).get(j);
    }

    @Override
    public void set(int i, int j, double value) {
        if (i >= this.rows() || i < 0) {
            throw new IndexOutOfBoundsException("row " + i + " is not a valid index");
        }
        if (j >= this.cols() || j < 0) {
            throw new IndexOutOfBoundsException("column " + j + " is not a valid index");
        }
        this.rows.get(i).set(j, value);
    }

    @Override
    public void increment(int i, int j, double value) {
        if (i >= this.rows() || i < 0) {
            throw new IndexOutOfBoundsException("row " + i + " is not a valid index");
        }
        if (j >= this.cols() || j < 0) {
            throw new IndexOutOfBoundsException("column " + j + " is not a valid index");
        }
        this.rows.get(i).increment(j, value);
    }

    @Override
    public int rows() {
        return this.rows.size();
    }

    @Override
    public int cols() {
        return this.rows.get(0).length();
    }

    @Override
    public Vec getRowView(int r) {
        if (r >= this.rows() || r < 0) {
            throw new IndexOutOfBoundsException("row " + r + " is not a valid index");
        }
        return this.rows.get(r);
    }

    @Override
    public void updateRow(int i, double c, Vec b) {
        this.rows.get(i).mutableAdd(c, b);
    }

    @Override
    public void mutableMultiply(double c) {
        for (Vec row : this.rows) {
            row.mutableMultiply(c);
        }
    }

    @Override
    public void mutableAdd(double c) {
        for (Vec row : this.rows) {
            row.mutableAdd(c);
        }
    }

    @Override
    public void zeroOut() {
        for (Vec row : this.rows) {
            row.zeroOut();
        }
    }

    @Override
    public MatrixOfVecs clone() {
        MatrixOfVecs clone = new MatrixOfVecs(this.rows);
        for (int i = 0; i < clone.rows.size(); ++i) {
            clone.rows.set(i, clone.rows.get(i).clone());
        }
        return clone;
    }

    @Override
    public boolean isSparce() {
        for (Vec v : this.rows) {
            if (!v.isSparse()) continue;
            return true;
        }
        return false;
    }
}

