/*
 * Decompiled with CFR 0.152.
 */
package jsat.linear.vectorcollection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import jsat.linear.Vec;
import jsat.linear.VecPaired;
import jsat.linear.VecPairedComparable;
import jsat.linear.distancemetrics.DistanceMetric;
import jsat.linear.vectorcollection.VectorCollection;
import jsat.linear.vectorcollection.VectorCollectionFactory;
import jsat.utils.BoundedSortedList;
import jsat.utils.DoubleList;
import jsat.utils.ProbailityMatch;

public class VectorArray<V extends Vec>
extends ArrayList<V>
implements VectorCollection<V> {
    private static final long serialVersionUID = 5365949686370986234L;
    private DistanceMetric distanceMetric;
    private List<Double> distCache;

    public VectorArray(DistanceMetric distanceMetric, int initialCapacity) {
        super(initialCapacity);
        this.distanceMetric = distanceMetric;
        if (distanceMetric.supportsAcceleration()) {
            this.distCache = new DoubleList(initialCapacity);
        }
    }

    public VectorArray(DistanceMetric distanceMetric, Collection<? extends V> c) {
        super(c);
        this.distanceMetric = distanceMetric;
        if (distanceMetric.supportsAcceleration()) {
            this.distCache = distanceMetric.getAccelerationCache(this);
        }
    }

    public VectorArray(DistanceMetric distanceMetric) {
        this.distanceMetric = distanceMetric;
        if (distanceMetric.supportsAcceleration()) {
            this.distCache = new DoubleList();
        }
    }

    public DistanceMetric getDistanceMetric() {
        return this.distanceMetric;
    }

    public void setDistanceMetric(DistanceMetric distanceMetric) {
        this.distanceMetric = distanceMetric;
        this.distCache = distanceMetric.supportsAcceleration() ? distanceMetric.getAccelerationCache(this) : null;
    }

    @Override
    public boolean add(V e) {
        boolean toRet = super.add(e);
        if (this.distCache != null) {
            this.distCache.addAll(this.distanceMetric.getQueryInfo((Vec)e));
        }
        return toRet;
    }

    @Override
    public boolean addAll(Collection<? extends V> c) {
        boolean toRet = super.addAll(c);
        if (this.distCache != null) {
            for (Vec v : c) {
                this.distCache.addAll(this.distanceMetric.getQueryInfo(v));
            }
        }
        return toRet;
    }

    @Override
    public V remove(int index) {
        this.distCache = null;
        return (V)((Vec)super.remove(index));
    }

    @Override
    public List<? extends VecPaired<V, Double>> search(Vec query, double range) {
        ArrayList<VecPairedComparable<Vec, Double>> list = new ArrayList<VecPairedComparable<Vec, Double>>();
        List<Double> qi = this.distanceMetric.getQueryInfo(query);
        for (int i = 0; i < this.size(); ++i) {
            double distance = this.distanceMetric.dist(i, query, qi, this, this.distCache);
            if (!(distance <= range)) continue;
            list.add(new VecPairedComparable<Vec, Double>((Vec)this.get(i), distance));
        }
        Collections.sort(list);
        return list;
    }

    @Override
    public List<? extends VecPaired<V, Double>> search(Vec query, int neighbors) {
        BoundedSortedList knns = new BoundedSortedList(neighbors);
        List<Double> qi = this.distanceMetric.getQueryInfo(query);
        for (int i = 0; i < this.size(); ++i) {
            double distance = this.distanceMetric.dist(i, query, qi, this, this.distCache);
            knns.add(new ProbailityMatch(distance, this.get(i)));
        }
        ArrayList<VecPaired<Vec, Double>> knnsList = new ArrayList<VecPaired<Vec, Double>>(knns.size());
        for (int i = 0; i < knns.size(); ++i) {
            ProbailityMatch pm = (ProbailityMatch)knns.get(i);
            knnsList.add(new VecPaired<Vec, Double>((Vec)pm.getMatch(), pm.getProbability()));
        }
        return knnsList;
    }

    @Override
    public VectorArray<V> clone() {
        VectorArray<V> clone = new VectorArray<V>(this.distanceMetric, this);
        return clone;
    }

    public static class VectorArrayFactory<V extends Vec>
    implements VectorCollectionFactory<V> {
        private static final long serialVersionUID = -7470849503958877157L;

        @Override
        public VectorCollection<V> getVectorCollection(List<V> source, DistanceMetric distanceMetric) {
            return new VectorArray<V>(distanceMetric, source);
        }

        @Override
        public VectorCollection<V> getVectorCollection(List<V> source, DistanceMetric distanceMetric, ExecutorService threadpool) {
            return this.getVectorCollection(source, distanceMetric);
        }

        @Override
        public VectorArrayFactory<V> clone() {
            return new VectorArrayFactory<V>();
        }
    }
}

