/*
 * Decompiled with CFR 0.152.
 */
package jsat.linear.vectorcollection.lsh;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import jsat.distributions.Normal;
import jsat.linear.DenseVector;
import jsat.linear.Vec;
import jsat.linear.VecPaired;
import jsat.linear.VecPairedComparable;
import jsat.linear.distancemetrics.DistanceMetric;
import jsat.linear.distancemetrics.EuclideanDistance;
import jsat.linear.distancemetrics.ManhattanDistance;
import jsat.utils.IntList;
import jsat.utils.IntSet;
import jsat.utils.random.XORWOW;

public class E2LSH<V extends Vec> {
    private List<V> vecs;
    private DistanceMetric dm;
    private double radius;
    private double eps;
    private double p1;
    private double p2;
    private int w;
    private double c;
    private double delta = Double.NaN;
    private int L;
    private int k;
    private List<Double> distCache;
    private Vec[][] h;
    private double[][] b;
    private List<Map<Integer, List<Integer>>> tables;

    public E2LSH(List<V> vecs, double radius, double eps, int w, int k, double delta, DistanceMetric dm, List<Double> distCache) {
        this.vecs = vecs;
        this.setRadius(radius);
        this.delta = delta;
        this.setEps(eps);
        this.w = w <= 0 ? 4 : w;
        this.setDistanceMetric(dm);
        this.distCache = distCache;
        this.k = k <= 0 ? (int)Math.ceil(Math.log(vecs.size()) / Math.log(1.0 / this.p2)) : k;
        if (delta <= 0.0 || delta >= 1.0) {
            throw new IllegalArgumentException("dleta must be in range (0,1)");
        }
        this.L = (int)Math.ceil(Math.log(1.0 / delta) / -Math.log(1.0 - Math.pow(this.p1, this.k)));
        XORWOW rand = new XORWOW();
        this.createTablesAndHashes(rand);
    }

    public E2LSH(List<V> vecs, double radius, double eps, int w, int k, double delta, DistanceMetric dm) {
        this(vecs, radius, eps, w, k, delta, dm, dm.getAccelerationCache(vecs));
    }

    public List<? extends VecPaired<Vec, Double>> searchR(Vec q) {
        return this.searchR(q, false);
    }

    public List<? extends VecPaired<Vec, Double>> searchR(Vec q, boolean approx) {
        int id;
        Iterator<Object> iterator;
        ArrayList<VecPairedComparable<Vec, Double>> toRet = new ArrayList<VecPairedComparable<Vec, Double>>();
        IntSet candidates = new IntSet();
        for (int l = 0; l < this.L; ++l) {
            int hash = this.hash(l, q);
            List<Integer> list = this.tables.get(l).get(hash);
            iterator = list.iterator();
            while (iterator.hasNext()) {
                id = (Integer)iterator.next();
                candidates.add(id);
            }
        }
        List<Double> q_qi = this.dm.getQueryInfo(q);
        double R = approx ? this.radius * this.getC() : this.radius;
        iterator = candidates.iterator();
        while (iterator.hasNext()) {
            id = (Integer)iterator.next();
            double trueDist = this.dm.dist(id, q, q_qi, this.vecs, this.distCache);
            if (!(trueDist <= R)) continue;
            toRet.add(new VecPairedComparable<Vec, Double>((Vec)this.vecs.get(id), trueDist));
        }
        Collections.sort(toRet);
        return toRet;
    }

    private int hash(int l, Vec v) {
        int[] vals = new int[this.k];
        for (int i = 0; i < this.k; ++i) {
            vals[i] = (int)Math.floor((v.dot(this.h[l][i]) / this.radius + this.b[l][i]) / (double)this.w);
        }
        return Arrays.hashCode(vals);
    }

    private void setEps(double eps) {
        this.eps = eps;
        this.c = eps + 1.0;
    }

    public double getC() {
        return this.c;
    }

    public double getRadius() {
        return this.radius;
    }

    public int getL() {
        return this.L;
    }

    private static double getP2L2(double w, double c) {
        return 1.0 - 2.0 * Normal.cdf(-w / c, 0.0, 1.0) - 2.0 / (Math.sqrt(Math.PI * 2) * w / c) * (1.0 - Math.exp(-w * w / (2.0 * c * c)));
    }

    private static double getP2L1(double w, double c) {
        return 2.0 * Math.atan(w / c) / Math.PI - Math.log(1.0 + Math.pow(w / c, 2.0)) / (Math.PI * w / c);
    }

    private void createTablesAndHashes(Random rand) {
        int l;
        int D = ((Vec)this.vecs.get(0)).length();
        this.h = new Vec[this.L][this.k];
        this.b = new double[this.L][this.k];
        for (l = 0; l < this.L; ++l) {
            for (int i = 0; i < this.k; ++i) {
                DenseVector dv = new DenseVector(D);
                for (int j = 0; j < D; ++j) {
                    dv.set(j, rand.nextGaussian());
                }
                this.h[l][i] = dv;
                this.b[l][i] = rand.nextDouble() * (double)this.w;
            }
        }
        this.tables = new ArrayList<Map<Integer, List<Integer>>>(this.L);
        for (l = 0; l < this.L; ++l) {
            this.tables.add(new HashMap());
            for (int id = 0; id < this.vecs.size(); ++id) {
                int hash = this.hash(l, (Vec)this.vecs.get(id));
                IntList ints = this.tables.get(l).get(hash);
                if (ints == null) {
                    ints = new IntList(3);
                    this.tables.get(l).put(hash, ints);
                }
                ints.add((Integer)id);
            }
        }
    }

    private void setDistanceMetric(DistanceMetric dm) {
        if (dm instanceof EuclideanDistance || dm instanceof ManhattanDistance) {
            this.dm = dm;
            if (dm instanceof EuclideanDistance) {
                this.p1 = E2LSH.getP2L2(this.w, 1.0);
                this.p2 = E2LSH.getP2L2(this.w, this.c);
            } else {
                this.p1 = E2LSH.getP2L1(this.w, 1.0);
                this.p2 = E2LSH.getP2L1(this.w, this.c);
            }
        } else {
            throw new IllegalArgumentException("only Euclidean and Manhatan (L1 and L2 norm) distances are supported");
        }
    }

    private void setRadius(double radius) {
        if (Double.isInfinite(radius) || Double.isNaN(radius) || radius <= 0.0) {
            throw new IllegalArgumentException("Radius must be a positive constant, not " + radius);
        }
        this.radius = radius;
    }
}

