/*
 * Decompiled with CFR 0.152.
 */
package jsat.lossfunctions;

import jsat.lossfunctions.LossR;

public class HuberLoss
implements LossR {
    private static final long serialVersionUID = -4463269746356262940L;
    private double c;

    public HuberLoss(double c) {
        this.c = c;
    }

    public HuberLoss() {
        this(1.0);
    }

    public static double loss(double pred, double y, double c) {
        double x = y - pred;
        if (Math.abs(x) <= c) {
            return x * x * 0.5;
        }
        return c * (Math.abs(x) - c / 2.0);
    }

    public static double deriv(double pred, double y, double c) {
        double x = pred - y;
        if (Math.abs(x) <= c) {
            return x;
        }
        return c * Math.signum(x);
    }

    public static double deriv2(double pred, double y, double c) {
        if (Math.abs(pred - y) < c) {
            return 1.0;
        }
        return 0.0;
    }

    public static double regress(double score) {
        return score;
    }

    @Override
    public double getLoss(double pred, double y) {
        return HuberLoss.loss(pred, y, this.c);
    }

    @Override
    public double getDeriv(double pred, double y) {
        return HuberLoss.deriv(pred, y, this.c);
    }

    @Override
    public double getDeriv2(double pred, double y) {
        return HuberLoss.deriv2(pred, y, this.c);
    }

    @Override
    public double getDeriv2Max() {
        return 1.0;
    }

    @Override
    public HuberLoss clone() {
        return new HuberLoss(this.c);
    }

    @Override
    public double getRegression(double score) {
        return score;
    }
}

