/*
 * Decompiled with CFR 0.152.
 */
package jsat.testing.onesample;

import jsat.distributions.StudentT;
import jsat.linear.Vec;
import jsat.testing.StatisticTest;
import jsat.testing.onesample.OneSampleTest;
import jsat.text.GreekLetters;

public class TTest
implements OneSampleTest {
    private StudentT tDist;
    private StatisticTest.H1 h1;
    private double hypothMean;
    private double sampleMean;
    private double sampleDev;
    private double sampleSize;

    public TTest(StatisticTest.H1 h1, double hypothMean, double sampleMean, double sampleDev, double sampleSize) {
        this.h1 = h1;
        this.hypothMean = hypothMean;
        this.sampleMean = sampleMean;
        this.sampleDev = sampleDev;
        this.sampleSize = sampleSize;
        this.tDist = new StudentT(sampleSize - 1.0);
    }

    public TTest(double hypothMean, double sampleMean, double sampleDev, double sampleSize) {
        this(StatisticTest.H1.NOT_EQUAL, hypothMean, sampleMean, sampleDev, sampleSize);
    }

    public TTest(StatisticTest.H1 h1, double hypothMean, Vec data) {
        this(h1, hypothMean, data.mean(), data.standardDeviation(), data.length());
    }

    public TTest() {
        this(1.0, 2.0, 2.0, 2.0);
    }

    @Override
    public void setTestUsingData(Vec data) {
        this.sampleMean = data.mean();
        this.sampleDev = data.standardDeviation();
        this.sampleSize = data.length();
        this.tDist.setDf(this.sampleSize - 1.0);
    }

    @Override
    public String[] getTestVars() {
        return new String[]{GreekLetters.bar("x"), "\u03c3", "n"};
    }

    @Override
    public void setTestVars(double[] testVars) {
        this.sampleMean = testVars[0];
        this.sampleDev = testVars[1];
        this.sampleSize = testVars[2];
        this.tDist.setDf(this.sampleSize - 1.0);
    }

    @Override
    public String getAltVar() {
        return "\u03bc0";
    }

    @Override
    public void setAltVar(double altVar) {
        this.hypothMean = altVar;
    }

    @Override
    public String getNullVar() {
        return "\u03bc";
    }

    @Override
    public StatisticTest.H1[] validAlternate() {
        return new StatisticTest.H1[]{StatisticTest.H1.LESS_THAN, StatisticTest.H1.NOT_EQUAL, StatisticTest.H1.GREATER_THAN};
    }

    @Override
    public void setAltHypothesis(StatisticTest.H1 h1) {
        this.h1 = h1;
    }

    @Override
    public String testName() {
        return "T Test";
    }

    @Override
    public double pValue() {
        double tScore = (this.sampleMean - this.hypothMean) * Math.sqrt(this.sampleSize) / this.sampleDev;
        if (this.h1 == StatisticTest.H1.NOT_EQUAL) {
            return this.tDist.cdf(-Math.abs(tScore)) * 2.0;
        }
        if (this.h1 == StatisticTest.H1.LESS_THAN) {
            return this.tDist.cdf(tScore);
        }
        return 1.0 - this.tDist.cdf(tScore);
    }
}

