/*
 * Decompiled with CFR 0.152.
 */
package jsat.utils;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import jsat.utils.IntList;

public class IntSet
extends AbstractSet<Integer>
implements Serializable {
    private static final long serialVersionUID = -2675363824037596497L;
    private static final int defaultSize = 8;
    private int[] store;
    private int size;

    public IntSet(int initialSize) {
        this.store = new int[initialSize];
        this.size = 0;
    }

    public IntSet(Set<Integer> set) {
        this(set.size());
        for (Integer integer : set) {
            this.add(integer);
        }
    }

    public IntSet(Collection<Integer> collection) {
        this();
        for (Integer integer : collection) {
            this.add(integer);
        }
    }

    public static IntSet from(int ... ints) {
        return new IntSet(IntList.view(ints, ints.length));
    }

    public IntSet() {
        this(8);
    }

    @Override
    public boolean add(Integer e) {
        if (e == null) {
            return false;
        }
        int insertionPoint = Arrays.binarySearch(this.store, 0, this.size, e);
        if (insertionPoint >= 0) {
            return false;
        }
        insertionPoint = -insertionPoint - 1;
        if (this.size >= this.store.length) {
            this.store = Arrays.copyOf(this.store, Math.max(1, this.store.length) * 2);
        }
        for (int i = this.size; i > insertionPoint; --i) {
            this.store[i] = this.store[i - 1];
        }
        this.store[insertionPoint] = e;
        ++this.size;
        return true;
    }

    public boolean contains(int o) {
        int insertionPoint = Arrays.binarySearch(this.store, 0, this.size, o);
        return insertionPoint >= 0;
    }

    @Override
    public boolean contains(Object o) {
        if (o != null && o instanceof Integer) {
            return this.contains((Integer)o);
        }
        return false;
    }

    @Override
    public Iterator<Integer> iterator() {
        Iterator<Integer> iterator = new Iterator<Integer>(){
            int index = 0;
            boolean canRemove = false;

            @Override
            public boolean hasNext() {
                return this.index < IntSet.this.size;
            }

            @Override
            public Integer next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("The whole set has been iterated");
                }
                this.canRemove = true;
                return IntSet.this.store[this.index++];
            }

            @Override
            public void remove() {
                if (!this.canRemove) {
                    throw new IllegalStateException("Can not remove, remove can only occur after a successful call to next");
                }
                for (int i = this.index; i < IntSet.this.size; ++i) {
                    ((IntSet)IntSet.this).store[i - 1] = IntSet.this.store[i];
                }
                --this.index;
                IntSet.this.size--;
                this.canRemove = false;
            }
        };
        return iterator;
    }

    @Override
    public int size() {
        return this.size;
    }
}

