/*
 * Decompiled with CFR 0.152.
 */
package jsat.utils;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class ListUtils {
    private ListUtils() {
    }

    public static <T> List<List<T>> splitList(List<T> source, int count) {
        if (count <= 0) {
            throw new RuntimeException("Chunks must be greater then 0, not " + count);
        }
        ArrayList<List<T>> chunks = new ArrayList<List<T>>(count);
        int baseSize = source.size() / count;
        int remainder = source.size() % count;
        int start = 0;
        for (int i = 0; i < count; ++i) {
            int end = start + baseSize;
            if (remainder-- > 0) {
                ++end;
            }
            chunks.add(source.subList(start, end));
            start = end;
        }
        return chunks;
    }

    public static <T> List<T> mergedView(final List<T> left, final List<T> right) {
        AbstractList merged = new AbstractList<T>(){

            @Override
            public T get(int index) {
                if (index < left.size()) {
                    return left.get(index);
                }
                if (index - left.size() < right.size()) {
                    return right.get(index - left.size());
                }
                throw new IndexOutOfBoundsException("List of lengt " + this.size() + " has no index " + index);
            }

            @Override
            public int size() {
                return left.size() + right.size();
            }
        };
        return merged;
    }

    public static void swap(List list, int i, int j) {
        Object tmp = list.get(i);
        list.set(i, list.get(j));
        list.set(j, tmp);
    }

    public static <T> List<T> collectFutures(Collection<Future<T>> futures) throws ExecutionException, InterruptedException {
        ArrayList<T> collected = new ArrayList<T>(futures.size());
        for (Future<T> future : futures) {
            collected.add(future.get());
        }
        return collected;
    }

    public static void addRange(Collection<Integer> c, int start, int to, int step) {
        if (step <= 0) {
            throw new RuntimeException("Would create an infinite loop");
        }
        for (int i = start; i < to; i += step) {
            c.add(i);
        }
    }

    public static <T> void randomSample(List<T> source, List<T> dest, int samples, Random rand) {
        ListUtils.randomSample(source, dest, samples, rand);
    }

    public static <T> void randomSample(Collection<T> source, Collection<T> dest, int samples, Random rand) {
        if (samples > source.size()) {
            throw new IllegalArgumentException("Can not obtain a number of samples larger than the source population");
        }
        if (samples <= 0) {
            throw new IllegalArgumentException("Sample size must be positive");
        }
        int remainingPopulation = source.size();
        for (T member : source) {
            if (rand.nextInt(remainingPopulation) < samples) {
                dest.add(member);
                --samples;
            }
            --remainingPopulation;
        }
    }

    public static <T> void randomSample(List<T> source, List<T> dest, int samples) {
        ListUtils.randomSample(source, dest, samples, new Random());
    }
}

