/*
 * Decompiled with CFR 0.152.
 */
package jsat.classifiers.evaluation;

import jsat.classifiers.CategoricalData;
import jsat.classifiers.CategoricalResults;
import jsat.classifiers.evaluation.ClassificationScore;

public class Accuracy
implements ClassificationScore {
    private static final long serialVersionUID = 397690693205481128L;
    private double correct;
    private double total;

    public Accuracy() {
    }

    public Accuracy(Accuracy toClone) {
        this.correct = toClone.correct;
        this.total = toClone.total;
    }

    @Override
    public void addResult(CategoricalResults prediction, int trueLabel, double weight) {
        if (prediction.mostLikely() == trueLabel) {
            this.correct += weight;
        }
        this.total += weight;
    }

    @Override
    public void addResults(ClassificationScore other) {
        Accuracy otherObj = (Accuracy)other;
        this.correct += otherObj.correct;
        this.total += otherObj.total;
    }

    @Override
    public void prepare(CategoricalData toPredict) {
        this.correct = 0.0;
        this.total = 0.0;
    }

    @Override
    public double getScore() {
        return this.correct / this.total;
    }

    @Override
    public boolean lowerIsBetter() {
        return false;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof Accuracy;
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public Accuracy clone() {
        return new Accuracy(this);
    }

    @Override
    public String getName() {
        return "Accuracy";
    }
}

