/*
 * Decompiled with CFR 0.152.
 */
package jsat.classifiers.trees;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import jsat.classifiers.CategoricalData;
import jsat.classifiers.CategoricalResults;
import jsat.classifiers.ClassificationDataSet;
import jsat.classifiers.Classifier;
import jsat.classifiers.DataPoint;
import jsat.classifiers.DataPointPair;
import jsat.classifiers.trees.ImpurityScore;
import jsat.exceptions.FailedToFitException;
import jsat.linear.Vec;
import jsat.math.OnLineStatistics;
import jsat.parameters.Parameter;
import jsat.parameters.Parameterized;
import jsat.regression.RegressionDataSet;
import jsat.regression.Regressor;
import jsat.utils.DoubleList;
import jsat.utils.FakeExecutor;
import jsat.utils.IntList;
import jsat.utils.IntSet;
import jsat.utils.PairedReturn;
import jsat.utils.QuickSort;
import jsat.utils.concurrent.AtomicDouble;

public class DecisionStump
implements Classifier,
Regressor,
Parameterized {
    private static final long serialVersionUID = -2849268862089019514L;
    private int splittingAttribute;
    private CategoricalData predicting;
    private CategoricalData[] catAttributes;
    private int numNumericFeatures;
    private List<Double> boundries;
    private List<Integer> owners;
    private CategoricalResults[] results;
    protected double[] pathRatio;
    private double[] regressionResults;
    private ImpurityScore.ImpurityMeasure gainMethod = ImpurityScore.ImpurityMeasure.INFORMATION_GAIN_RATIO;
    private boolean removeContinuousAttributes = false;
    private int minResultSplitSize = 10;
    private static final double almost0 = 1.0E-6;
    private static final double almost1 = 0.999999;

    public void setRemoveContinuousAttributes(boolean removeContinuousAttributes) {
        this.removeContinuousAttributes = removeContinuousAttributes;
    }

    public void setGainMethod(ImpurityScore.ImpurityMeasure gainMethod) {
        this.gainMethod = gainMethod;
    }

    public ImpurityScore.ImpurityMeasure getGainMethod() {
        return this.gainMethod;
    }

    protected int numNumeric() {
        return this.numNumericFeatures;
    }

    protected int numCategorical() {
        return this.catAttributes.length;
    }

    public void setMinResultSplitSize(int minResultSplitSize) {
        if (minResultSplitSize <= 1) {
            throw new ArithmeticException("Min split size must be a positive value ");
        }
        this.minResultSplitSize = minResultSplitSize;
    }

    public int getMinResultSplitSize() {
        return this.minResultSplitSize;
    }

    public int getSplittingAttribute() {
        if (this.splittingAttribute < this.catAttributes.length) {
            return this.numNumericFeatures + this.splittingAttribute;
        }
        int numerAttribute = this.splittingAttribute - this.catAttributes.length;
        return numerAttribute;
    }

    public void setPredicting(CategoricalData predicting) {
        this.predicting = predicting;
    }

    @Override
    public double regress(DataPoint data) {
        if (this.regressionResults == null) {
            throw new RuntimeException("Decusion stump has not been trained for regression");
        }
        int path = this.whichPath(data);
        if (path >= 0) {
            return this.regressionResults[path];
        }
        double avg = 0.0;
        for (int i = 0; i < this.pathRatio.length; ++i) {
            avg += this.pathRatio[i] * this.regressionResults[i];
        }
        return avg;
    }

    @Override
    public void train(RegressionDataSet dataSet) {
        this.train(dataSet, new FakeExecutor());
    }

    @Override
    public void train(RegressionDataSet dataSet, ExecutorService threadPool) {
        IntSet options = new IntSet(dataSet.getNumFeatures());
        for (int i = 0; i < dataSet.getNumFeatures(); ++i) {
            options.add(Integer.valueOf(i));
        }
        List<List<DataPointPair<Double>>> split = this.trainR(dataSet.getDPPList(), options, threadPool);
        if (split == null) {
            throw new FailedToFitException("Tree could not be fit, make sure your data is good. Potentially file a bug");
        }
    }

    protected double getGain(ImpurityScore origScore, List<List<DataPointPair<Integer>>> aSplit) {
        ImpurityScore[] scores = this.getSplitScores(aSplit);
        return ImpurityScore.gain(origScore, scores);
    }

    private ImpurityScore[] getSplitScores(List<List<DataPointPair<Integer>>> aSplit) {
        ImpurityScore[] scores = new ImpurityScore[aSplit.size()];
        for (int i = 0; i < aSplit.size(); ++i) {
            scores[i] = this.getClassGainScore(aSplit.get(i));
        }
        return scores;
    }

    public int whichPath(DataPoint data) {
        int paths = this.getNumberOfPaths();
        if (paths < 0) {
            return paths;
        }
        if (paths == 1) {
            return 0;
        }
        if (this.splittingAttribute < this.catAttributes.length) {
            return data.getCategoricalValue(this.splittingAttribute);
        }
        int numerAttribute = this.splittingAttribute - this.catAttributes.length;
        double val = data.getNumericalValues().get(numerAttribute);
        if (Double.isNaN(val)) {
            return -1;
        }
        if (this.results != null) {
            int pos = Collections.binarySearch(this.boundries, val);
            pos = pos < 0 ? -pos - 1 : pos;
            return this.owners.get(pos);
        }
        if (this.regressionResults.length == 1) {
            return 0;
        }
        if (val <= this.regressionResults[2]) {
            return 0;
        }
        return 1;
    }

    public int getNumberOfPaths() {
        if (this.results != null) {
            return this.results.length;
        }
        if (this.catAttributes != null) {
            if (this.regressionResults.length == 1) {
                return 1;
            }
            if (this.splittingAttribute < this.catAttributes.length) {
                return this.catAttributes[this.splittingAttribute].getNumOfCategories();
            }
            return 2;
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public CategoricalResults classify(DataPoint data) {
        if (this.results == null) {
            throw new RuntimeException("DecisionStump has not been trained for classification");
        }
        int path = this.whichPath(data);
        if (path >= 0) {
            return this.results[path];
        }
        Vec tmp = this.results[0].getVecView().clone();
        tmp.mutableMultiply(this.pathRatio[0]);
        for (int i = 1; i < this.results.length; ++i) {
            tmp.mutableAdd(this.pathRatio[i], this.results[i].getVecView());
        }
        return new CategoricalResults(tmp.arrayCopy());
    }

    public CategoricalResults result(int i) {
        if (i < 0 || i >= this.getNumberOfPaths()) {
            throw new IndexOutOfBoundsException("Invalid path, can to return a result for path " + i);
        }
        return this.results[i];
    }

    @Override
    public void trainC(ClassificationDataSet dataSet, ExecutorService threadPool) {
        IntSet splitOptions = new IntSet(dataSet.getNumFeatures());
        for (int i = 0; i < dataSet.getNumFeatures(); ++i) {
            splitOptions.add(Integer.valueOf(i));
        }
        this.predicting = dataSet.getPredicting();
        this.trainC(dataSet.getAsDPPList(), splitOptions, threadPool);
    }

    @Override
    public void trainC(ClassificationDataSet dataSet) {
        this.trainC(dataSet, null);
    }

    public List<List<DataPointPair<Integer>>> trainC(List<DataPointPair<Integer>> dataPoints, Set<Integer> options) {
        return this.trainC(dataPoints, options, null);
    }

    public List<List<DataPointPair<Integer>>> trainC(final List<DataPointPair<Integer>> dataPoints, Set<Integer> options, ExecutorService ex) {
        if (this.predicting == null) {
            throw new RuntimeException("Predicting value has not been set");
        }
        if (ex == null) {
            ex = new FakeExecutor();
        }
        this.catAttributes = dataPoints.get(0).getDataPoint().getCategoricalData();
        this.numNumericFeatures = dataPoints.get(0).getVector().length();
        final ImpurityScore origScoreObj = this.getClassGainScore(dataPoints);
        double origScore = origScoreObj.getScore();
        if (origScore == 0.0 || dataPoints.size() < this.minResultSplitSize * 2) {
            this.results = new CategoricalResults[1];
            this.results[0] = new CategoricalResults(this.predicting.getNumOfCategories());
            this.results[0].setProb(dataPoints.get(0).getPair(), 1.0);
            this.pathRatio = new double[]{0.0};
            ArrayList<List<DataPointPair<Integer>>> toReturn = new ArrayList<List<DataPointPair<Integer>>>();
            toReturn.add(dataPoints);
            return toReturn;
        }
        final List<List<DataPointPair<Integer>>> bestSplit = Collections.synchronizedList(new ArrayList());
        final AtomicDouble bestGain = new AtomicDouble(-1.0);
        final DoubleList bestRatio = new DoubleList();
        this.splittingAttribute = -1;
        final CountDownLatch latch = new CountDownLatch(options.size());
        final ThreadLocal<List<DataPointPair<Integer>>> localList = new ThreadLocal<List<DataPointPair<Integer>>>(){

            @Override
            protected List<DataPointPair<Integer>> initialValue() {
                return new ArrayList<DataPointPair<Integer>>(dataPoints);
            }
        };
        for (final int attribute_to_consider : options) {
            ex.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    double gain;
                    List aSplit;
                    List DPs = (List)localList.get();
                    int attribute = attribute_to_consider;
                    double[] gainRet = new double[]{Double.NaN};
                    gainRet[0] = Double.NaN;
                    PairedReturn tmp = null;
                    ImpurityScore[] split_scores = null;
                    double weightScale = 1.0;
                    if (attribute < DecisionStump.this.catAttributes.length) {
                        aSplit = DecisionStump.listOfLists(DecisionStump.this.catAttributes[attribute].getNumOfCategories());
                        split_scores = new ImpurityScore[aSplit.size()];
                        for (int i = 0; i < split_scores.length; ++i) {
                            split_scores[i] = new ImpurityScore(DecisionStump.this.predicting.getNumOfCategories(), DecisionStump.this.gainMethod);
                        }
                        ArrayList wasMissing = new ArrayList(0);
                        double missingSum = 0.0;
                        for (Object dpp : DPs) {
                            int val = ((DataPointPair)dpp).getDataPoint().getCategoricalValue(attribute);
                            double weight = ((DataPointPair)dpp).getDataPoint().getWeight();
                            if (val >= 0) {
                                ((List)aSplit.get(val)).add(dpp);
                                split_scores[val].addPoint(weight, (int)((Integer)((DataPointPair)dpp).getPair()));
                                continue;
                            }
                            wasMissing.add(dpp);
                            missingSum += weight;
                        }
                        int pathsTaken = 0;
                        for (List split : aSplit) {
                            if (split.isEmpty()) continue;
                            ++pathsTaken;
                        }
                        if (pathsTaken <= 1) {
                            latch.countDown();
                            return;
                        }
                        if (missingSum > 0.0) {
                            double newSum = origScoreObj.getSumOfWeights() - missingSum;
                            weightScale = newSum / origScoreObj.getSumOfWeights();
                            double[] fracs = new double[split_scores.length];
                            for (int i = 0; i < fracs.length; ++i) {
                                fracs[i] = split_scores[i].getSumOfWeights() / newSum;
                            }
                            DecisionStump.distributMissing(aSplit, fracs, wasMissing);
                        }
                    } else {
                        int N = DecisionStump.this.predicting.getNumOfCategories();
                        tmp = DecisionStump.this.createNumericCSplit(DPs, N, attribute -= DecisionStump.this.catAttributes.length, aSplit = DecisionStump.listOfLists(2), origScoreObj, gainRet, split_scores = new ImpurityScore[2]);
                        if (tmp == null) {
                            latch.countDown();
                            return;
                        }
                        attribute += DecisionStump.this.catAttributes.length;
                    }
                    if (!Double.isNaN(gainRet[0])) {
                        gain = gainRet[0];
                    } else {
                        if (split_scores == null) {
                            split_scores = DecisionStump.this.getSplitScores(aSplit);
                        }
                        gain = ImpurityScore.gain(origScoreObj, weightScale, split_scores);
                    }
                    if (gain > bestGain.get()) {
                        DoubleList doubleList = bestRatio;
                        synchronized (doubleList) {
                            if (gain > bestGain.get()) {
                                int i;
                                bestGain.set(gain);
                                DecisionStump.this.splittingAttribute = attribute;
                                bestSplit.clear();
                                bestSplit.addAll(aSplit);
                                bestRatio.clear();
                                double sum = 1.0E-8;
                                for (i = 0; i < split_scores.length; ++i) {
                                    sum += split_scores[i].getSumOfWeights();
                                    bestRatio.add(split_scores[i].getSumOfWeights());
                                }
                                for (i = 0; i < split_scores.length; ++i) {
                                    bestRatio.set(i, bestRatio.getD(i) / sum);
                                }
                                if (attribute >= DecisionStump.this.catAttributes.length) {
                                    DecisionStump.this.boundries = (List)tmp.getFirstItem();
                                    DecisionStump.this.owners = (List)tmp.getSecondItem();
                                }
                            }
                        }
                    }
                    latch.countDown();
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException ex1) {
            Logger.getLogger(DecisionStump.class.getName()).log(Level.SEVERE, null, ex1);
            throw new FailedToFitException(ex1);
        }
        if (bestGain.get() <= 1.0E-9 || this.splittingAttribute == -1) {
            bestSplit.clear();
            bestSplit.add(dataPoints);
            CategoricalResults badResult = new CategoricalResults(this.predicting.getNumOfCategories());
            for (DataPointPair<Integer> dpp : dataPoints) {
                badResult.incProb(dpp.getPair(), 1.0);
            }
            badResult.normalize();
            this.results = new CategoricalResults[]{badResult};
            this.pathRatio = new double[]{1.0};
            return bestSplit;
        }
        if (this.splittingAttribute < this.catAttributes.length || this.removeContinuousAttributes) {
            options.remove(this.splittingAttribute);
        }
        this.results = new CategoricalResults[bestSplit.size()];
        this.pathRatio = bestRatio.getVecView().arrayCopy();
        for (int i = 0; i < bestSplit.size(); ++i) {
            this.results[i] = new CategoricalResults(this.predicting.getNumOfCategories());
            for (DataPointPair<Integer> dpp : bestSplit.get(i)) {
                this.results[i].incProb(dpp.getPair(), dpp.getDataPoint().getWeight());
            }
            this.results[i].normalize();
        }
        return bestSplit;
    }

    private PairedReturn<List<Double>, List<Integer>> createNumericCSplit(List<DataPointPair<Integer>> dataPoints, int N, int attribute, List<List<DataPointPair<Integer>>> aSplit, ImpurityScore origScore, double[] finalGain, ImpurityScore[] subScores) {
        int i;
        double[] vals = new double[dataPoints.size()];
        int wasNaN = 0;
        for (int i2 = 0; i2 < dataPoints.size() - wasNaN; ++i2) {
            double val = dataPoints.get(i2).getVector().get(attribute);
            if (!Double.isNaN(val)) {
                vals[i2] = val;
                continue;
            }
            Collections.swap(dataPoints, vals.length - wasNaN - 1, i2);
            ++wasNaN;
            --i2;
        }
        List<List<?>> paired = Arrays.asList(dataPoints);
        QuickSort.sort(vals, 0, vals.length - wasNaN, paired);
        double bestGain = Double.NEGATIVE_INFINITY;
        double bestSplit = Double.NEGATIVE_INFINITY;
        int splitIndex = -1;
        ImpurityScore rightSide = origScore.clone();
        ImpurityScore leftSide = new ImpurityScore(N, this.gainMethod);
        double nanWeightRemoved = 0.0;
        for (int i3 = dataPoints.size() - wasNaN; i3 < dataPoints.size(); ++i3) {
            double weight = dataPoints.get(i3).getDataPoint().getWeight();
            int truth = dataPoints.get(i3).getPair();
            nanWeightRemoved += weight;
            rightSide.removePoint(weight, truth);
        }
        double wholeRescale = rightSide.getSumOfWeights() / (rightSide.getSumOfWeights() + nanWeightRemoved);
        for (i = 0; i < this.minResultSplitSize; ++i) {
            if (i >= dataPoints.size()) {
                System.out.println("WHAT?");
            }
            double weight = dataPoints.get(i).getDataPoint().getWeight();
            int truth = dataPoints.get(i).getPair();
            leftSide.addPoint(weight, truth);
            rightSide.removePoint(weight, truth);
        }
        for (i = this.minResultSplitSize; i < dataPoints.size() - this.minResultSplitSize - 1 - wasNaN; ++i) {
            DataPointPair<Integer> dpp = dataPoints.get(i);
            rightSide.removePoint(dpp.getDataPoint(), (int)dpp.getPair());
            leftSide.addPoint(dpp.getDataPoint(), (int)dpp.getPair());
            double leftVal = vals[i];
            double rightVal = vals[i + 1];
            if (rightVal - leftVal < 1.0E-14) continue;
            subScores[0] = leftSide;
            subScores[1] = rightSide;
            ImpurityScore[] impurityScoreArray = new ImpurityScore[]{leftSide, rightSide};
            double curGain = ImpurityScore.gain(origScore, wholeRescale, impurityScoreArray);
            if (!(curGain >= bestGain)) continue;
            double curSplit = (leftVal + rightVal) / 2.0;
            bestGain = curGain;
            bestSplit = curSplit;
            splitIndex = i + 1;
        }
        if (splitIndex == -1) {
            return null;
        }
        if (finalGain != null) {
            finalGain[0] = bestGain;
        }
        aSplit.set(0, new ArrayList<DataPointPair<Integer>>(dataPoints.subList(0, splitIndex)));
        aSplit.set(1, new ArrayList<DataPointPair<Integer>>(dataPoints.subList(splitIndex, dataPoints.size() - wasNaN)));
        if (wasNaN > 0) {
            double weightScale = leftSide.getSumOfWeights() / (leftSide.getSumOfWeights() + rightSide.getSumOfWeights() + 0.0);
            DecisionStump.distributMissing(aSplit, new double[]{weightScale, 1.0 - weightScale}, dataPoints.subList(dataPoints.size() - wasNaN, dataPoints.size()));
        }
        PairedReturn<List<Double>, List<Integer>> tmp = new PairedReturn<List<Double>, List<Integer>>(Arrays.asList(bestSplit, Double.POSITIVE_INFINITY), Arrays.asList(0, 1));
        return tmp;
    }

    /*
     * WARNING - void declaration
     */
    protected static <T> void distributMissing(List<List<DataPointPair<T>>> splits, List<DataPointPair<T>> hadMissing) {
        void var5_9;
        double[] fracs = new double[splits.size()];
        for (int i = 0; i < splits.size(); ++i) {
            for (DataPointPair<T> dataPointPair : splits.get(i)) {
                int n = i;
                fracs[n] = fracs[n] + dataPointPair.getDataPoint().getWeight();
            }
        }
        double sum = 0.0;
        for (double d : fracs) {
            sum += d;
        }
        boolean bl = false;
        while (var5_9 < fracs.length) {
            void v1 = var5_9++;
            fracs[v1] = fracs[v1] / sum;
        }
        DecisionStump.distributMissing(splits, fracs, hadMissing);
    }

    protected static <T> void distributMissing(List<List<DataPointPair<T>>> splits, double[] fracs, List<DataPointPair<T>> hadMissing) {
        for (DataPointPair<T> dpp : hadMissing) {
            DataPoint dp = dpp.getDataPoint();
            Vec vec = dp.getNumericalValues();
            int[] cats = dp.getCategoricalValues();
            CategoricalData[] lab = dp.getCategoricalData();
            for (int i = 0; i < fracs.length; ++i) {
                double nw = fracs[i] * dp.getWeight();
                if (Double.isNaN(nw) || nw <= 1.0E-13) continue;
                DataPointPair<T> dp_i = new DataPointPair<T>(new DataPoint(vec, cats, lab, nw), dpp.getPair());
                splits.get(i).add(dp_i);
            }
        }
    }

    public List<List<DataPointPair<Double>>> trainR(List<DataPointPair<Double>> dataPoints, Set<Integer> options) {
        return this.trainR(dataPoints, options, new FakeExecutor());
    }

    public List<List<DataPointPair<Double>>> trainR(final List<DataPointPair<Double>> dataPoints, Set<Integer> options, ExecutorService ex) {
        this.catAttributes = dataPoints.get(0).getDataPoint().getCategoricalData();
        this.numNumericFeatures = dataPoints.get(0).getVector().length();
        if (dataPoints.size() <= this.minResultSplitSize * 2) {
            this.splittingAttribute = this.catAttributes.length;
            this.regressionResults = new double[1];
            double avg = 0.0;
            double sum = 0.0;
            for (DataPointPair<Double> dpp : dataPoints) {
                double weight = dpp.getDataPoint().getWeight();
                avg += dpp.getPair() * weight;
                sum += weight;
            }
            this.regressionResults[0] = avg / sum;
            ArrayList<List<DataPointPair<Double>>> toRet = new ArrayList<List<DataPointPair<Double>>>(1);
            toRet.add(dataPoints);
            return toRet;
        }
        final ArrayList<List<DataPointPair<Double>>> bestSplit = new ArrayList<List<DataPointPair<Double>>>();
        final AtomicDouble lowestSplitSqrdError = new AtomicDouble(Double.MAX_VALUE);
        final ThreadLocal<List<DataPointPair<Double>>> localList = new ThreadLocal<List<DataPointPair<Double>>>(){

            @Override
            protected List<DataPointPair<Double>> initialValue() {
                return new ArrayList<DataPointPair<Double>>(dataPoints);
            }
        };
        final CountDownLatch latch = new CountDownLatch(options.size());
        Iterator<Integer> toRet = options.iterator();
        while (toRet.hasNext()) {
            int attribute_to_consider;
            final int attribute = attribute_to_consider = toRet.next().intValue();
            ex.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    double[] thisRatio;
                    List DPs = (List)localList.get();
                    List thisSplit = null;
                    double thisSplitSqrdErr = Double.MAX_VALUE;
                    double[] thisMeans = null;
                    if (attribute < DecisionStump.this.catAttributes.length) {
                        int i;
                        thisSplit = DecisionStump.listOfListsD(DecisionStump.this.catAttributes[attribute].getNumOfCategories());
                        OnLineStatistics[] stats = new OnLineStatistics[thisSplit.size()];
                        thisRatio = new double[thisSplit.size()];
                        for (int i2 = 0; i2 < thisSplit.size(); ++i2) {
                            stats[i2] = new OnLineStatistics();
                        }
                        ArrayList wasMissing = new ArrayList(0);
                        for (DataPointPair dpp : DPs) {
                            int category = dpp.getDataPoint().getCategoricalValue(attribute);
                            if (category >= 0) {
                                ((List)thisSplit.get(category)).add(dpp);
                                stats[category].add((Double)dpp.getPair(), dpp.getDataPoint().getWeight());
                                continue;
                            }
                            wasMissing.add(dpp);
                        }
                        thisMeans = new double[stats.length];
                        thisSplitSqrdErr = 0.0;
                        double sum = 0.0;
                        for (i = 0; i < stats.length; ++i) {
                            thisRatio[i] = stats[i].getSumOfWeights();
                            sum += thisRatio[i];
                            thisSplitSqrdErr += stats[i].getVarance() * stats[i].getSumOfWeights();
                            thisMeans[i] = stats[i].getMean();
                        }
                        i = 0;
                        while (i < stats.length) {
                            int n = i++;
                            thisRatio[n] = thisRatio[n] / sum;
                        }
                        if (!wasMissing.isEmpty()) {
                            DecisionStump.distributMissing(thisSplit, thisRatio, wasMissing);
                        }
                    } else {
                        final int numAttri = attribute - DecisionStump.this.catAttributes.length;
                        Comparator<DataPointPair<Double>> dppDoubleSorter = new Comparator<DataPointPair<Double>>(){

                            @Override
                            public int compare(DataPointPair<Double> o1, DataPointPair<Double> o2) {
                                return Double.compare(o1.getVector().get(numAttri), o2.getVector().get(numAttri));
                            }
                        };
                        Collections.sort(DPs, dppDoubleSorter);
                        OnLineStatistics rightSide = new OnLineStatistics();
                        OnLineStatistics leftSide = new OnLineStatistics();
                        int nans = 0;
                        for (DataPointPair dpp : DPs) {
                            if (!Double.isNaN(dpp.getVector().get(numAttri))) {
                                rightSide.add((Double)dpp.getPair(), dpp.getDataPoint().getWeight());
                                continue;
                            }
                            ++nans;
                        }
                        int bestS = 0;
                        thisSplitSqrdErr = Double.POSITIVE_INFINITY;
                        double allWeight = rightSide.getSumOfWeights();
                        thisMeans = new double[3];
                        thisRatio = new double[2];
                        for (int i = 0; i < DPs.size() - nans; ++i) {
                            DataPointPair dpp = (DataPointPair)DPs.get(i);
                            double weight = dpp.getDataPoint().getWeight();
                            double val = (Double)dpp.getPair();
                            rightSide.remove(val, weight);
                            leftSide.add(val, weight);
                            if (i < DecisionStump.this.minResultSplitSize) continue;
                            if (i > DPs.size() - DecisionStump.this.minResultSplitSize - nans) break;
                            double tmpSVariance = rightSide.getVarance() * rightSide.getSumOfWeights() + leftSide.getVarance() * leftSide.getSumOfWeights();
                            if (!(tmpSVariance < thisSplitSqrdErr) || Double.isInfinite(tmpSVariance)) continue;
                            thisSplitSqrdErr = tmpSVariance;
                            bestS = i;
                            thisMeans[0] = leftSide.getMean();
                            thisMeans[1] = rightSide.getMean();
                            thisMeans[2] = (((DataPointPair)DPs.get(bestS)).getVector().get(numAttri) + ((DataPointPair)DPs.get(bestS + 1)).getVector().get(numAttri)) / 2.0;
                            thisRatio[0] = leftSide.getSumOfWeights() / allWeight;
                            thisRatio[1] = rightSide.getSumOfWeights() / allWeight;
                        }
                        if (DPs.size() - nans >= DecisionStump.this.minResultSplitSize) {
                            thisSplit = DecisionStump.listOfListsD(2);
                            ((List)thisSplit.get(0)).addAll(DPs.subList(0, bestS + 1));
                            ((List)thisSplit.get(1)).addAll(DPs.subList(bestS + 1, DPs.size() - nans));
                            if (nans > 0) {
                                DecisionStump.distributMissing(thisSplit, thisRatio, DPs.subList(DPs.size() - nans, DPs.size()));
                            }
                        } else {
                            thisSplitSqrdErr = Double.NEGATIVE_INFINITY;
                        }
                    }
                    if (Math.abs(thisSplitSqrdErr) < 1.0E-13) {
                        thisSplitSqrdErr = Math.abs(thisSplitSqrdErr);
                    }
                    if (thisSplitSqrdErr >= 0.0 && thisSplitSqrdErr < lowestSplitSqrdError.get()) {
                        List list = bestSplit;
                        synchronized (list) {
                            if (thisSplitSqrdErr < lowestSplitSqrdError.get()) {
                                lowestSplitSqrdError.set(thisSplitSqrdErr);
                                bestSplit.clear();
                                bestSplit.addAll(thisSplit);
                                DecisionStump.this.splittingAttribute = attribute;
                                DecisionStump.access$1102(DecisionStump.this, thisMeans);
                                DecisionStump.this.pathRatio = thisRatio;
                            }
                        }
                    }
                    latch.countDown();
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException ex1) {
            Logger.getLogger(DecisionStump.class.getName()).log(Level.SEVERE, null, ex1);
            throw new FailedToFitException(ex1);
        }
        if (this.splittingAttribute < this.catAttributes.length || this.removeContinuousAttributes) {
            options.remove(this.splittingAttribute);
        }
        if (bestSplit.size() == 0) {
            return null;
        }
        return bestSplit;
    }

    private static List<List<DataPointPair<Integer>>> listOfLists(int n) {
        ArrayList<List<DataPointPair<Integer>>> aSplit = new ArrayList<List<DataPointPair<Integer>>>(n);
        for (int i = 0; i < n; ++i) {
            aSplit.add(new ArrayList());
        }
        return aSplit;
    }

    private static List<List<DataPointPair<Double>>> listOfListsD(int n) {
        ArrayList<List<DataPointPair<Double>>> aSplit = new ArrayList<List<DataPointPair<Double>>>(n);
        for (int i = 0; i < n; ++i) {
            aSplit.add(new ArrayList());
        }
        return aSplit;
    }

    @Override
    public boolean supportsWeightedData() {
        return true;
    }

    private ImpurityScore getClassGainScore(List<DataPointPair<Integer>> dataPoints) {
        ImpurityScore cgs = new ImpurityScore(this.predicting.getNumOfCategories(), this.gainMethod);
        for (DataPointPair<Integer> dpp : dataPoints) {
            cgs.addPoint(dpp.getDataPoint(), (int)dpp.getPair());
        }
        return cgs;
    }

    @Override
    public DecisionStump clone() {
        DecisionStump copy = new DecisionStump();
        if (this.catAttributes != null) {
            copy.catAttributes = CategoricalData.copyOf(this.catAttributes);
        }
        if (this.results != null) {
            copy.results = new CategoricalResults[this.results.length];
            for (int i = 0; i < this.results.length; ++i) {
                copy.results[i] = this.results[i].clone();
            }
        }
        copy.removeContinuousAttributes = this.removeContinuousAttributes;
        copy.splittingAttribute = this.splittingAttribute;
        if (this.boundries != null) {
            copy.boundries = new DoubleList(this.boundries);
        }
        if (this.owners != null) {
            copy.owners = new IntList(this.owners);
        }
        if (this.predicting != null) {
            copy.predicting = this.predicting.clone();
        }
        if (this.regressionResults != null) {
            copy.regressionResults = Arrays.copyOf(this.regressionResults, this.regressionResults.length);
        }
        if (this.pathRatio != null) {
            copy.pathRatio = Arrays.copyOf(this.pathRatio, this.pathRatio.length);
        }
        copy.minResultSplitSize = this.minResultSplitSize;
        copy.gainMethod = this.gainMethod;
        copy.numNumericFeatures = this.numNumericFeatures;
        return copy;
    }

    @Override
    public List<Parameter> getParameters() {
        return Parameter.getParamsFromMethods(this);
    }

    @Override
    public Parameter getParameter(String paramName) {
        return Parameter.toParameterMap(this.getParameters()).get(paramName);
    }

    static /* synthetic */ double[] access$1102(DecisionStump x0, double[] x1) {
        x0.regressionResults = x1;
        return x1;
    }
}

