/*
 * Decompiled with CFR 0.152.
 */
package jsat.clustering;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import jsat.DataSet;
import jsat.classifiers.DataPoint;
import jsat.clustering.Clusterer;

public abstract class ClustererBase
implements Clusterer {
    private static final long serialVersionUID = 4359554809306681680L;

    @Override
    public List<List<DataPoint>> cluster(DataSet dataSet) {
        int[] assignments = this.cluster(dataSet, (int[])null);
        return ClustererBase.createClusterListFromAssignmentArray(assignments, dataSet);
    }

    @Override
    public List<List<DataPoint>> cluster(DataSet dataSet, ExecutorService threadpool) {
        int[] assignments = this.cluster(dataSet, threadpool, null);
        return ClustererBase.createClusterListFromAssignmentArray(assignments, dataSet);
    }

    public static List<List<DataPoint>> createClusterListFromAssignmentArray(int[] assignments, DataSet dataSet) {
        ArrayList<List<DataPoint>> clusterings = new ArrayList<List<DataPoint>>();
        for (int i = 0; i < dataSet.getSampleSize(); ++i) {
            while (clusterings.size() <= assignments[i]) {
                clusterings.add(new ArrayList());
            }
            if (assignments[i] < 0) continue;
            ((List)clusterings.get(assignments[i])).add(dataSet.getDataPoint(i));
        }
        return clusterings;
    }

    public static List<DataPoint> getDatapointsFromCluster(int c, int[] assignments, DataSet dataSet, int[] indexFrom) {
        ArrayList<DataPoint> list = new ArrayList<DataPoint>();
        int pos = 0;
        for (int i = 0; i < dataSet.getSampleSize(); ++i) {
            if (assignments[i] != c) continue;
            list.add(dataSet.getDataPoint(i));
            if (indexFrom == null) continue;
            indexFrom[pos++] = i;
        }
        return list;
    }

    @Override
    public boolean supportsWeightedData() {
        return false;
    }

    @Override
    public abstract Clusterer clone();
}

