/*
 * Decompiled with CFR 0.152.
 */
package jsat.clustering.evaluation.intra;

import java.util.List;
import jsat.DataSet;
import jsat.classifiers.DataPoint;
import jsat.clustering.evaluation.intra.IntraClusterEvaluation;
import jsat.linear.distancemetrics.DistanceMetric;
import jsat.linear.distancemetrics.EuclideanDistance;

public class MeanDistance
implements IntraClusterEvaluation {
    private DistanceMetric dm;

    public MeanDistance() {
        this(new EuclideanDistance());
    }

    public MeanDistance(DistanceMetric dm) {
        this.dm = dm;
    }

    public MeanDistance(MeanDistance toCopy) {
        this(toCopy.dm.clone());
    }

    @Override
    public double evaluate(int[] designations, DataSet dataSet, int clusterID) {
        double distances = 0.0;
        for (int i = 0; i < dataSet.getSampleSize(); ++i) {
            for (int j = i + 1; j < dataSet.getSampleSize(); ++j) {
                if (designations[i] != clusterID) continue;
                distances += this.dm.dist(dataSet.getDataPoint(i).getNumericalValues(), dataSet.getDataPoint(j).getNumericalValues());
            }
        }
        return distances / (double)(dataSet.getSampleSize() * (dataSet.getSampleSize() - 1));
    }

    @Override
    public double evaluate(List<DataPoint> dataPoints) {
        double distances = 0.0;
        for (int i = 0; i < dataPoints.size(); ++i) {
            for (int j = i + 1; j < dataPoints.size(); ++j) {
                distances += this.dm.dist(dataPoints.get(i).getNumericalValues(), dataPoints.get(j).getNumericalValues());
            }
        }
        return distances / (double)(dataPoints.size() * (dataPoints.size() - 1));
    }

    @Override
    public MeanDistance clone() {
        return new MeanDistance(this);
    }
}

