/*
 * Decompiled with CFR 0.152.
 */
package jsat.clustering.hierarchical;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import jsat.DataSet;
import jsat.SimpleDataSet;
import jsat.clustering.ClusterFailureException;
import jsat.clustering.KClusterer;
import jsat.clustering.KClustererBase;
import jsat.clustering.evaluation.ClusterEvaluation;

public class DivisiveGlobalClusterer
extends KClustererBase {
    private static final long serialVersionUID = -9117751530105155090L;
    private KClusterer baseClusterer;
    private ClusterEvaluation clusterEvaluation;
    private int[] splitList;
    private int[] fullDesignations;
    private DataSet originalDataSet;

    public DivisiveGlobalClusterer(KClusterer baseClusterer, ClusterEvaluation clusterEvaluation) {
        this.baseClusterer = baseClusterer;
        this.clusterEvaluation = clusterEvaluation;
    }

    public DivisiveGlobalClusterer(DivisiveGlobalClusterer toCopy) {
        this.baseClusterer = toCopy.baseClusterer.clone();
        this.clusterEvaluation = toCopy.clusterEvaluation.clone();
        if (toCopy.splitList != null) {
            this.splitList = Arrays.copyOf(toCopy.splitList, toCopy.splitList.length);
        }
        if (toCopy.fullDesignations != null) {
            this.fullDesignations = Arrays.copyOf(toCopy.fullDesignations, toCopy.fullDesignations.length);
        }
        this.originalDataSet = toCopy.originalDataSet.shallowClone();
    }

    @Override
    public int[] cluster(DataSet dataSet, int[] designations) {
        return this.cluster(dataSet, 2, (int)Math.sqrt(dataSet.getSampleSize()), designations);
    }

    @Override
    public int[] cluster(DataSet dataSet, ExecutorService threadpool, int[] designations) {
        return this.cluster(dataSet, 2, (int)Math.sqrt(dataSet.getSampleSize()), threadpool, designations);
    }

    @Override
    public int[] cluster(DataSet dataSet, int clusters, ExecutorService threadpool, int[] designations) {
        return this.cluster(dataSet, clusters, clusters, threadpool, designations);
    }

    @Override
    public int[] cluster(DataSet dataSet, int clusters, int[] designations) {
        return this.cluster(dataSet, clusters, clusters, designations);
    }

    @Override
    public int[] cluster(DataSet dataSet, int lowK, int highK, ExecutorService threadpool, int[] designations) {
        int k;
        if (designations == null) {
            designations = new int[dataSet.getSampleSize()];
        }
        int[] fakeWorld = new int[dataSet.getSampleSize()];
        int[][] subDesignation = new int[highK][];
        int[][] originalPositions = new int[highK][dataSet.getSampleSize()];
        ArrayList pointsInCluster = new ArrayList(highK);
        for (int i = 0; i < highK; ++i) {
            pointsInCluster.add(new ArrayList(dataSet.getSampleSize()));
        }
        double[] splitEvaluation = new double[highK];
        Arrays.fill(splitEvaluation, Double.NEGATIVE_INFINITY);
        this.splitList = new int[highK * 2 - 2];
        int bestK = -1;
        double bestKEval = Double.POSITIVE_INFINITY;
        for (k = 1; k < highK; ++k) {
            double bestSplitVal = Double.POSITIVE_INFINITY;
            int bestID = -1;
            for (int z = 0; z < k; ++z) {
                if (Double.isNaN(splitEvaluation[z])) continue;
                if (splitEvaluation[z] == Double.NEGATIVE_INFINITY) {
                    List clusterPointsZ = (List)pointsInCluster.get(z);
                    clusterPointsZ.clear();
                    for (int i = 0; i < dataSet.getSampleSize(); ++i) {
                        if (designations[i] != z) continue;
                        originalPositions[z][clusterPointsZ.size()] = i;
                        clusterPointsZ.add(dataSet.getDataPoint(i));
                    }
                    subDesignation[z] = new int[clusterPointsZ.size()];
                    if (clusterPointsZ.isEmpty()) {
                        splitEvaluation[z] = Double.NaN;
                        continue;
                    }
                    SimpleDataSet subDataSet = new SimpleDataSet(clusterPointsZ);
                    try {
                        this.baseClusterer.cluster((DataSet)subDataSet, 2, subDesignation[z]);
                    }
                    catch (ClusterFailureException ex) {
                        splitEvaluation[z] = Double.NaN;
                        continue;
                    }
                }
                System.arraycopy(designations, 0, fakeWorld, 0, fakeWorld.length);
                for (int i = 0; i < subDesignation[z].length; ++i) {
                    if (subDesignation[z][i] != 1) continue;
                    fakeWorld[originalPositions[z][i]] = k;
                }
                try {
                    splitEvaluation[z] = this.clusterEvaluation.evaluate(fakeWorld, dataSet);
                }
                catch (Exception ex) {
                    splitEvaluation[z] = Double.NaN;
                    continue;
                }
                if (!(splitEvaluation[z] < bestSplitVal)) continue;
                bestSplitVal = splitEvaluation[z];
                bestID = z;
            }
            for (int i = 0; i < subDesignation[bestID].length; ++i) {
                if (subDesignation[bestID][i] != 1) continue;
                designations[originalPositions[bestID][i]] = k;
            }
            splitEvaluation[k] = Double.NEGATIVE_INFINITY;
            splitEvaluation[bestID] = Double.NEGATIVE_INFINITY;
            this.splitList[(k - 1) * 2] = bestID;
            this.splitList[(k - 1) * 2 + 1] = k;
            if (lowK - 1 > k || k > highK - 1 || !(bestSplitVal < bestKEval)) continue;
            bestKEval = bestSplitVal;
            bestK = k;
            System.out.println("Best k is now " + k + " at " + bestKEval);
        }
        this.fullDesignations = Arrays.copyOf(designations, designations.length);
        for (k = this.splitList.length / 2 - 1; k >= bestK; --k) {
            if (this.splitList[k * 2] == this.splitList[k * 2 + 1]) continue;
            for (int j = 0; j < designations.length; ++j) {
                if (designations[j] != this.splitList[k * 2 + 1]) continue;
                designations[j] = this.splitList[k * 2];
            }
        }
        this.originalDataSet = dataSet;
        return designations;
    }

    public int[] clusterSplit(int targetK) {
        if (this.originalDataSet == null) {
            throw new ClusterFailureException("No prior cluster stored");
        }
        int[] newDesignations = Arrays.copyOf(this.fullDesignations, this.fullDesignations.length);
        for (int k = this.splitList.length / 2 - 1; k >= targetK; --k) {
            if (this.splitList[k * 2] == this.splitList[k * 2 + 1]) continue;
            for (int j = 0; j < newDesignations.length; ++j) {
                if (newDesignations[j] != this.splitList[k * 2 + 1]) continue;
                newDesignations[j] = this.splitList[k * 2];
            }
        }
        return newDesignations;
    }

    @Override
    public int[] cluster(DataSet dataSet, int lowK, int highK, int[] designations) {
        return this.cluster(dataSet, lowK, highK, null, designations);
    }

    @Override
    public DivisiveGlobalClusterer clone() {
        return new DivisiveGlobalClusterer(this);
    }
}

