/*
 * Decompiled with CFR 0.152.
 */
package jsat.clustering.hierarchical;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.concurrent.ExecutorService;
import jsat.DataSet;
import jsat.SimpleDataSet;
import jsat.classifiers.DataPoint;
import jsat.clustering.ClusterFailureException;
import jsat.clustering.KClusterer;
import jsat.clustering.KClustererBase;
import jsat.clustering.evaluation.ClusterEvaluation;

public class DivisiveLocalClusterer
extends KClustererBase {
    private static final long serialVersionUID = 8616401472810067778L;
    private KClusterer baseClusterer;
    private ClusterEvaluation clusterEvaluation;

    public DivisiveLocalClusterer(KClusterer baseClusterer, ClusterEvaluation clusterEvaluation) {
        this.baseClusterer = baseClusterer;
        this.clusterEvaluation = clusterEvaluation;
    }

    public DivisiveLocalClusterer(DivisiveLocalClusterer toCopy) {
        this(toCopy.baseClusterer.clone(), toCopy.clusterEvaluation.clone());
    }

    @Override
    public int[] cluster(DataSet dataSet, int[] designations) {
        return this.cluster(dataSet, 2, (int)Math.sqrt(dataSet.getSampleSize()), designations);
    }

    @Override
    public int[] cluster(DataSet dataSet, ExecutorService threadpool, int[] designations) {
        return this.cluster(dataSet, 2, (int)Math.sqrt(dataSet.getSampleSize()), threadpool, designations);
    }

    @Override
    public int[] cluster(DataSet dataSet, int clusters, ExecutorService threadpool, int[] designations) {
        if (designations == null) {
            designations = new int[dataSet.getSampleSize()];
        }
        int[][] subDesignation = new int[clusters][];
        int[][] originalPositions = new int[clusters][dataSet.getSampleSize()];
        final double[] splitEvaluation = new double[clusters];
        PriorityQueue<Integer> clusterToSplit = new PriorityQueue<Integer>(clusters, new Comparator<Integer>(){

            @Override
            public int compare(Integer t, Integer t1) {
                return Double.compare(splitEvaluation[t], splitEvaluation[t1]);
            }
        });
        clusterToSplit.add(0);
        Arrays.fill(designations, 0);
        if (threadpool == null) {
            this.baseClusterer.cluster(dataSet, 2, designations);
        } else {
            this.baseClusterer.cluster(dataSet, 2, threadpool, designations);
        }
        subDesignation[0] = Arrays.copyOf(designations, designations.length);
        for (int i = 0; i < originalPositions[0].length; ++i) {
            originalPositions[0][i] = i;
        }
        ArrayList<DataPoint> dpSubC1 = new ArrayList<DataPoint>();
        ArrayList<DataPoint> dpSubC2 = new ArrayList<DataPoint>();
        for (int k = 1; k < clusters; ++k) {
            int useSplit = clusterToSplit.poll();
            int newClusterID = k;
            dpSubC1.clear();
            dpSubC2.clear();
            for (int i = 0; i < subDesignation[useSplit].length; ++i) {
                int origPos = originalPositions[useSplit][i];
                if (subDesignation[useSplit][i] == 0) {
                    dpSubC1.add(dataSet.getDataPoint(origPos));
                    continue;
                }
                dpSubC2.add(dataSet.getDataPoint(origPos));
                designations[origPos] = newClusterID;
            }
            this.computeSubClusterSplit(subDesignation, useSplit, dpSubC1, dataSet, designations, originalPositions, splitEvaluation, clusterToSplit, threadpool);
            this.computeSubClusterSplit(subDesignation, newClusterID, dpSubC2, dataSet, designations, originalPositions, splitEvaluation, clusterToSplit, threadpool);
        }
        return designations;
    }

    private void computeSubClusterSplit(int[][] subDesignation, int originalCluster, List<DataPoint> listOfDataPointsInCluster, DataSet fullDataSet, int[] fullDesignations, int[][] originalPositions, double[] splitEvaluation, PriorityQueue<Integer> clusterToSplit, ExecutorService threadpool) {
        subDesignation[originalCluster] = new int[listOfDataPointsInCluster.size()];
        int pos = 0;
        for (int i = 0; i < fullDataSet.getSampleSize(); ++i) {
            if (fullDesignations[i] != originalCluster) continue;
            originalPositions[originalCluster][pos++] = i;
        }
        SimpleDataSet dpSubC1DataSet = new SimpleDataSet(listOfDataPointsInCluster);
        try {
            if (threadpool == null) {
                this.baseClusterer.cluster((DataSet)dpSubC1DataSet, 2, subDesignation[originalCluster]);
            } else {
                this.baseClusterer.cluster((DataSet)dpSubC1DataSet, 2, threadpool, subDesignation[originalCluster]);
            }
            splitEvaluation[originalCluster] = this.clusterEvaluation.evaluate(subDesignation[originalCluster], dpSubC1DataSet);
            clusterToSplit.add(originalCluster);
        }
        catch (ClusterFailureException ex) {
            splitEvaluation[originalCluster] = Double.POSITIVE_INFINITY;
        }
    }

    @Override
    public int[] cluster(DataSet dataSet, int clusters, int[] designations) {
        return this.cluster(dataSet, clusters, null, designations);
    }

    @Override
    public int[] cluster(DataSet dataSet, int lowK, int highK, ExecutorService threadpool, int[] designations) {
        return this.cluster(dataSet, lowK, threadpool, designations);
    }

    @Override
    public int[] cluster(DataSet dataSet, int lowK, int highK, int[] designations) {
        return this.cluster(dataSet, lowK, highK, null, designations);
    }

    @Override
    public DivisiveLocalClusterer clone() {
        return new DivisiveLocalClusterer(this);
    }
}

