/*
 * Decompiled with CFR 0.152.
 */
package jsat.datatransform;

import jsat.DataSet;
import jsat.classifiers.DataPoint;
import jsat.datatransform.DataTransform;
import jsat.datatransform.InPlaceTransform;
import jsat.linear.Vec;

public class UnitVarianceTransform
implements InPlaceTransform {
    private static final long serialVersionUID = 3645532503475641917L;
    private Vec stndDevs;

    public UnitVarianceTransform() {
    }

    public UnitVarianceTransform(DataSet d) {
        this.fit(d);
    }

    @Override
    public void fit(DataSet d) {
        this.stndDevs = d.getColumnMeanVariance()[1];
    }

    private UnitVarianceTransform(UnitVarianceTransform other) {
        this.stndDevs = other.stndDevs.clone();
    }

    @Override
    public DataPoint transform(DataPoint dp) {
        DataPoint newDp = dp.clone();
        this.mutableTransform(newDp);
        return newDp;
    }

    @Override
    public void mutableTransform(DataPoint dp) {
        dp.getNumericalValues().mutablePairwiseDivide(this.stndDevs);
    }

    @Override
    public boolean mutatesNominal() {
        return false;
    }

    @Override
    public DataTransform clone() {
        return new UnitVarianceTransform(this);
    }
}

