/*
 * Decompiled with CFR 0.152.
 */
package jsat.distributions;

import java.io.Serializable;
import java.util.Random;
import jsat.linear.DenseVector;
import jsat.linear.Vec;
import jsat.math.Function;
import jsat.math.FunctionBase;
import jsat.math.rootfinding.Zeroin;

public abstract class Distribution
implements Cloneable,
Serializable {
    public abstract double cdf(double var1);

    public double invCdf(double p) {
        return this.invCdf(p, new FunctionBase(){

            @Override
            public double f(Vec x) {
                return Distribution.this.cdf(x.get(0));
            }
        });
    }

    protected double invCdf(final double p, final Function cdf) {
        if (p < 0.0 || p > 1.0) {
            throw new ArithmeticException("Value of p must be in the range [0,1], not " + p);
        }
        double a = Double.isInfinite(this.min()) ? Double.MIN_VALUE : this.min();
        double b = Double.isInfinite(this.max()) ? Double.MAX_VALUE : this.max();
        Function newCDF = new Function(){

            @Override
            public double f(double ... x) {
                return cdf.f(x) - p;
            }

            @Override
            public double f(Vec x) {
                return this.f(x.get(0));
            }
        };
        return Zeroin.root(a, b, newCDF, p);
    }

    public abstract double mean();

    public double median() {
        return this.invCdf(0.5);
    }

    public abstract double mode();

    public abstract double variance();

    public abstract double skewness();

    public double standardDeviation() {
        return Math.sqrt(this.variance());
    }

    public abstract double min();

    public abstract double max();

    public double[] sample(int numSamples, Random rand) {
        double[] samples = new double[numSamples];
        for (int i = 0; i < samples.length; ++i) {
            samples[i] = this.invCdf(rand.nextDouble());
        }
        return samples;
    }

    public DenseVector sampleVec(int numSamples, Random rand) {
        return DenseVector.toDenseVec(this.sample(numSamples, rand));
    }

    public abstract Distribution clone();

    public static Function getFunctionCDF(final Distribution dist) {
        return new Function(){
            private static final long serialVersionUID = -3794266180670489168L;

            @Override
            public double f(double ... x) {
                return this.f(DenseVector.toDenseVec(x));
            }

            @Override
            public double f(Vec x) {
                return dist.cdf(x.get(0));
            }
        };
    }
}

