/*
 * Decompiled with CFR 0.152.
 */
package jsat.linear;

import java.util.Iterator;
import java.util.NoSuchElementException;
import jsat.linear.DenseVector;
import jsat.linear.IndexValue;
import jsat.linear.SparseVector;
import jsat.linear.Vec;

public class SubVector
extends Vec {
    private static final long serialVersionUID = -873882618035700676L;
    private int startPosition;
    private int length;
    private Vec vec;

    public SubVector(int startPosition, int length, Vec vec) {
        if (startPosition < 0 || startPosition >= vec.length()) {
            throw new IndexOutOfBoundsException("Start position out of bounds for input vector");
        }
        if (length + startPosition > vec.length()) {
            throw new IndexOutOfBoundsException("Length too long for start position for the given vector");
        }
        this.startPosition = startPosition;
        this.length = length;
        this.vec = vec;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public double get(int index) {
        if (index >= this.length) {
            throw new IndexOutOfBoundsException("Index of " + index + " can not be accessed for length of " + this.length);
        }
        return this.vec.get(this.startPosition + index);
    }

    @Override
    public void set(int index, double val) {
        if (index >= this.length) {
            throw new IndexOutOfBoundsException("Index of " + index + " can not be accessed for length of " + this.length);
        }
        this.vec.set(this.startPosition + index, val);
    }

    @Override
    public boolean isSparse() {
        return this.vec.isSparse();
    }

    @Override
    public Iterator<IndexValue> getNonZeroIterator(int start) {
        final Iterator<IndexValue> origIter = this.vec.getNonZeroIterator(this.startPosition + start);
        Iterator<IndexValue> newIter = new Iterator<IndexValue>(){
            IndexValue nextVal;
            IndexValue curVal;
            {
                this.nextVal = origIter.hasNext() ? (IndexValue)origIter.next() : new IndexValue(Integer.MAX_VALUE, Double.NaN);
                this.curVal = new IndexValue(-1, Double.NaN);
            }

            @Override
            public boolean hasNext() {
                return this.nextVal.getIndex() < SubVector.this.length + SubVector.this.startPosition;
            }

            @Override
            public IndexValue next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.curVal.setIndex(this.nextVal.getIndex() - SubVector.this.startPosition);
                this.curVal.setValue(this.nextVal.getValue());
                if (origIter.hasNext()) {
                    this.nextVal = (IndexValue)origIter.next();
                } else {
                    this.nextVal.setIndex(Integer.MAX_VALUE);
                }
                return this.curVal;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        };
        return newIter;
    }

    @Override
    public Vec clone() {
        if (this.vec.isSparse()) {
            return new SparseVector(this);
        }
        return new DenseVector(this);
    }
}

