/*
 * Decompiled with CFR 0.152.
 */
package jsat.linear.vectorcollection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import jsat.exceptions.FailedToFitException;
import jsat.linear.Vec;
import jsat.linear.VecPaired;
import jsat.linear.VecPairedComparable;
import jsat.linear.distancemetrics.DistanceMetric;
import jsat.linear.vectorcollection.IncrementalCollection;
import jsat.linear.vectorcollection.VectorCollection;
import jsat.linear.vectorcollection.VectorCollectionFactory;
import jsat.utils.BoundedSortedList;
import jsat.utils.DoubleList;
import jsat.utils.FakeExecutor;
import jsat.utils.IndexTable;
import jsat.utils.IntList;
import jsat.utils.ListUtils;
import jsat.utils.ProbailityMatch;
import jsat.utils.SystemInfo;

public class RandomBallCover<V extends Vec>
implements IncrementalCollection<V> {
    private static final long serialVersionUID = 2437771973228849200L;
    private DistanceMetric dm;
    private List<List<Integer>> ownedVecs;
    private List<DoubleList> ownedRDists;
    private List<Integer> R;
    private int size;
    private List<V> allVecs;
    private List<Double> distCache;
    double[] repRadius;

    public RandomBallCover(List<V> vecs, DistanceMetric dm, ExecutorService execServ) {
        this.dm = dm;
        this.size = vecs.size();
        this.allVecs = new ArrayList<V>(vecs);
        this.distCache = execServ instanceof FakeExecutor ? dm.getAccelerationCache(this.allVecs) : dm.getAccelerationCache(this.allVecs, execServ);
        IntList allIndices = new IntList(vecs.size());
        ListUtils.addRange(allIndices, 0, this.size, 1);
        try {
            this.setUp(allIndices, execServ);
        }
        catch (InterruptedException ex) {
            try {
                this.setUp(allIndices, new FakeExecutor());
            }
            catch (InterruptedException ex1) {
                throw new FailedToFitException(ex1);
            }
        }
    }

    public RandomBallCover(List<V> vecs, DistanceMetric dm) {
        this(vecs, dm, new FakeExecutor());
    }

    public RandomBallCover(DistanceMetric dm) {
        this.dm = dm;
        this.size = 0;
        this.allVecs = new ArrayList<V>();
        if (dm.supportsAcceleration()) {
            this.distCache = new DoubleList();
        }
        this.R = new IntList();
    }

    private RandomBallCover(RandomBallCover<V> other) {
        this.dm = other.dm.clone();
        this.size = other.size;
        if (other.allVecs != null) {
            this.allVecs = new ArrayList<V>(other.allVecs);
        }
        if (other.distCache != null) {
            this.distCache = new DoubleList(other.distCache);
        }
        if (other.ownedVecs != null) {
            this.ownedVecs = new ArrayList<List<Integer>>(other.ownedVecs.size());
        }
        if (other.ownedRDists != null) {
            this.ownedRDists = new ArrayList<DoubleList>(other.ownedRDists.size());
        }
        if (other.ownedRDists != null) {
            for (int i = 0; i < other.ownedRDists.size(); ++i) {
                this.ownedRDists.add(new DoubleList(other.ownedRDists.get(i)));
                this.ownedVecs.add(new IntList((Collection<Integer>)other.ownedVecs.get(i)));
            }
        }
        this.R = new IntList(other.R);
        if (other.repRadius != null) {
            this.repRadius = Arrays.copyOf(other.repRadius, other.repRadius.length);
        }
    }

    private void setUp(List<Integer> vecIndices, ExecutorService execServ) throws InterruptedException {
        int repCount = (int)Math.max(1.0, Math.sqrt(vecIndices.size()));
        Collections.shuffle(vecIndices);
        this.R = new IntList(vecIndices.subList(0, repCount));
        this.repRadius = new double[this.R.size()];
        this.ownedRDists = new ArrayList<DoubleList>(this.repRadius.length);
        vecIndices = new IntList(vecIndices.subList(repCount, vecIndices.size()));
        this.ownedVecs = new ArrayList<List<Integer>>(repCount);
        for (int i = 0; i < repCount; ++i) {
            this.ownedVecs.add(new IntList(repCount));
            this.ownedRDists.add(new DoubleList(repCount));
        }
        final CountDownLatch latch = new CountDownLatch(SystemInfo.LogicalCores);
        for (final List<Integer> subSet : ListUtils.splitList(vecIndices, SystemInfo.LogicalCores)) {
            execServ.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Iterator iterator = subSet.iterator();
                    while (iterator.hasNext()) {
                        int v = (Integer)iterator.next();
                        int bestRep = 0;
                        double bestDist = RandomBallCover.this.dm.dist(v, (Integer)RandomBallCover.this.R.get(0), (List<? extends Vec>)RandomBallCover.this.allVecs, (List<Double>)RandomBallCover.this.distCache);
                        for (int potentialRep = 1; potentialRep < RandomBallCover.this.R.size(); ++potentialRep) {
                            double d;
                            double tmp = RandomBallCover.this.dm.dist(v, (Integer)RandomBallCover.this.R.get(potentialRep), (List<? extends Vec>)RandomBallCover.this.allVecs, (List<Double>)RandomBallCover.this.distCache);
                            if (!(d < bestDist)) continue;
                            bestDist = tmp;
                            bestRep = potentialRep;
                        }
                        List list = (List)RandomBallCover.this.ownedVecs.get(bestRep);
                        synchronized (list) {
                            ((List)RandomBallCover.this.ownedVecs.get(bestRep)).add(v);
                            ((DoubleList)RandomBallCover.this.ownedRDists.get(bestRep)).add(bestDist);
                            RandomBallCover.this.repRadius[bestRep] = Math.max(RandomBallCover.this.repRadius[bestRep], bestDist);
                        }
                    }
                    latch.countDown();
                }
            });
        }
        latch.await();
    }

    @Override
    public List<? extends VecPaired<V, Double>> search(Vec query, double range) {
        ArrayList<VecPairedComparable<Vec, Double>> knn = new ArrayList<VecPairedComparable<Vec, Double>>();
        List<ProbailityMatch<Integer>> results = this.search_(query, range);
        for (ProbailityMatch<Integer> r : results) {
            knn.add(new VecPairedComparable<Vec, Double>((Vec)this.allVecs.get(r.getMatch()), r.getProbability()));
        }
        return knn;
    }

    private List<ProbailityMatch<Integer>> search_(Vec query, double range) {
        ArrayList<ProbailityMatch<Integer>> knn = new ArrayList<ProbailityMatch<Integer>>();
        List<Double> qi = this.dm.getQueryInfo(query);
        if (this.repRadius == null) {
            for (int i = 0; i < this.allVecs.size(); ++i) {
                knn.add(new ProbailityMatch<Integer>(this.dm.dist(i, query, qi, this.allVecs, this.distCache), i));
            }
            return knn;
        }
        double[] queryRDists = new double[this.R.size()];
        for (int i = 0; i < this.R.size(); ++i) {
            double d;
            queryRDists[i] = this.dm.dist(this.R.get(i), query, qi, this.allVecs, this.distCache);
            if (!(d <= range)) continue;
            knn.add(new ProbailityMatch<Integer>(queryRDists[i], this.R.get(i)));
        }
        IndexTable sorted = new IndexTable(queryRDists);
        for (int i_indx = 0; i_indx < this.R.size(); ++i_indx) {
            int i = sorted.index(i_indx);
            if (queryRDists[i] > range + this.repRadius[i]) continue;
            for (int j = 0; j < this.ownedVecs.get(i).size(); ++j) {
                double d;
                double rDist = this.ownedRDists.get(i).getD(j);
                if (queryRDists[i] > range + rDist) continue;
                double dist = this.dm.dist(this.ownedVecs.get(i).get(j), query, qi, this.allVecs, this.distCache);
                if (!(d <= range)) continue;
                knn.add(new ProbailityMatch<Integer>(dist, this.ownedVecs.get(i).get(j)));
            }
        }
        Collections.sort(knn);
        return knn;
    }

    @Override
    public List<? extends VecPaired<V, Double>> search(Vec query, int neighbors) {
        BoundedSortedList<VecPairedComparable<Vec, Double>> knn = new BoundedSortedList<VecPairedComparable<Vec, Double>>(neighbors);
        List<Double> qi = this.dm.getQueryInfo(query);
        if (this.repRadius == null) {
            for (int i = 0; i < this.allVecs.size(); ++i) {
                knn.add(new VecPairedComparable<Vec, Double>((Vec)this.allVecs.get(i), this.dm.dist(i, query, qi, this.allVecs, this.distCache)));
            }
            return knn;
        }
        double[] queryRDists = new double[this.R.size()];
        Arrays.fill(queryRDists, Double.MAX_VALUE);
        int bestRep = 0;
        for (int i = 0; i < this.R.size(); ++i) {
            double d;
            queryRDists[i] = this.dm.dist(this.R.get(i), query, qi, this.allVecs, this.distCache);
            if (!(d < queryRDists[bestRep])) continue;
            bestRep = i;
        }
        knn.add(new VecPairedComparable<Vec, Double>((Vec)this.allVecs.get(this.R.get(bestRep)), queryRDists[bestRep]));
        IndexTable it = new IndexTable(queryRDists);
        int kth_best_rept = neighbors < this.R.size() ? it.index(neighbors - 1) : -1;
        for (int v : this.ownedVecs.get(bestRep)) {
            knn.add(new VecPairedComparable<Vec, Double>((Vec)this.allVecs.get(v), this.dm.dist(v, query, qi, this.allVecs, this.distCache)));
        }
        for (int sorted_order = 1; sorted_order < this.R.size(); ++sorted_order) {
            int i = it.index(sorted_order);
            if (knn.size() == neighbors && (queryRDists[i] > (Double)((VecPairedComparable)knn.last()).getPair() + this.repRadius[i] || kth_best_rept >= 0 && queryRDists[i] > 3.0 * queryRDists[kth_best_rept])) continue;
            knn.add(new VecPairedComparable<Vec, Double>((Vec)this.allVecs.get(this.R.get(i)), queryRDists[i]));
            List<Integer> L_i_index = this.ownedVecs.get(i);
            DoubleList L_i_radius = this.ownedRDists.get(i);
            for (int j = 0; j < this.ownedVecs.get(i).size(); ++j) {
                double rDist = L_i_radius.getD(j);
                if (knn.size() == neighbors && queryRDists[i] > (Double)((VecPairedComparable)knn.last()).getPair() + rDist) continue;
                int indx = L_i_index.get(j);
                Vec v = (Vec)this.allVecs.get(indx);
                knn.add(new VecPairedComparable<Vec, Double>(v, this.dm.dist(indx, query, qi, this.allVecs, this.distCache)));
            }
        }
        return knn;
    }

    @Override
    public void insert(V x) {
        int new_indx = this.allVecs.size();
        this.allVecs.add(x);
        List<Double> qi = this.dm.getQueryInfo((Vec)x);
        if (this.distCache != null) {
            this.distCache.addAll(qi);
        }
        ++this.size;
        if (this.size < 10) {
            this.R.add(new_indx);
            return;
        }
        if (this.repRadius == null) {
            try {
                this.R.add(new_indx);
                this.setUp(new IntList(this.R), new FakeExecutor());
            }
            catch (InterruptedException ex) {
                throw new FailedToFitException(ex);
            }
            return;
        }
        double[] queryRDists = new double[this.R.size()];
        Arrays.fill(queryRDists, Double.MAX_VALUE);
        int bestRep = 0;
        for (int i = 0; i < this.R.size(); ++i) {
            double d;
            queryRDists[i] = this.dm.dist(this.R.get(i), (Vec)x, qi, (List<? extends Vec>)this.allVecs, this.distCache);
            if (!(d < queryRDists[bestRep])) continue;
            bestRep = i;
        }
        this.ownedVecs.get(bestRep).add(new_indx);
        this.ownedRDists.get(bestRep).add(queryRDists[bestRep]);
        this.repRadius[bestRep] = Math.max(this.repRadius[bestRep], queryRDists[bestRep]);
        if (Math.pow(Math.ceil(Math.sqrt(this.size)), 2.0) != (double)this.size) {
            return;
        }
        int new_r_vec_indx = -1;
        int R_pos = 0;
        for (int ran_val = new Random().nextInt(this.size - this.R.size() - 1); ran_val >= 0; ran_val -= this.ownedVecs.get(R_pos++).size()) {
            if (ran_val >= this.ownedVecs.get(R_pos).size()) {
                continue;
            }
            new_r_vec_indx = this.ownedVecs.get(R_pos).remove(ran_val);
            this.ownedRDists.get(R_pos).remove(ran_val);
            this.repRadius[R_pos] = 0.0;
            Object object = this.ownedRDists.get(R_pos).iterator();
            while (object.hasNext()) {
                double d = (Double)object.next();
                this.repRadius[R_pos] = Math.max(this.repRadius[R_pos], d);
            }
            break block3;
        }
        double max_radius = 0.0;
        for (double d : this.repRadius) {
            max_radius = Math.max(max_radius, d);
        }
        List<ProbailityMatch<Integer>> potentialChildren = this.search_((Vec)this.allVecs.get(new_r_vec_indx), max_radius);
        this.repRadius = Arrays.copyOf(this.repRadius, this.repRadius.length + 1);
        this.R.add(new_r_vec_indx);
        this.ownedRDists.add(new DoubleList());
        this.ownedVecs.add(new IntList());
        int r_new = this.R.size() - 1;
        int[] whoOwnsMe = new int[this.allVecs.size()];
        Arrays.fill(whoOwnsMe, -1);
        double[] distToMyOwner = new double[this.allVecs.size()];
        for (int i = 0; i < this.R.size() - 1; ++i) {
            List<Integer> L_ry = this.ownedVecs.get(i);
            for (int j = 0; j < L_ry.size(); ++j) {
                whoOwnsMe[L_ry.get((int)j).intValue()] = i;
                distToMyOwner[((Integer)L_ry.get((int)j)).intValue()] = this.ownedRDists.get(i).getD(j);
            }
        }
        boolean[] R_is_dirty = new boolean[this.R.size()];
        Arrays.fill(R_is_dirty, false);
        R_is_dirty[r_new] = true;
        for (ProbailityMatch probailityMatch : potentialChildren) {
            double d_y_ry;
            double d_y_r_new = probailityMatch.getProbability();
            int y_indx = (Integer)probailityMatch.getMatch();
            int r_y = whoOwnsMe[y_indx];
            if (r_y == -1 || !((d_y_ry = distToMyOwner[y_indx]) > d_y_r_new)) continue;
            R_is_dirty[r_y] = true;
            whoOwnsMe[y_indx] = r_new;
            distToMyOwner[y_indx] = d_y_r_new;
        }
        for (int r_indx = 0; r_indx < this.R.size(); ++r_indx) {
            if (!R_is_dirty[r_indx]) continue;
            this.repRadius[r_indx] = 0.0;
            this.ownedRDists.get(r_indx).clear();
            this.ownedVecs.get(r_indx).clear();
        }
        for (int i = 0; i < whoOwnsMe.length; ++i) {
            int n = whoOwnsMe[i];
            if (n == -1 || !R_is_dirty[n]) continue;
            this.repRadius[n] = Math.max(this.repRadius[n], distToMyOwner[i]);
            this.ownedRDists.get(n).add(distToMyOwner[i]);
            this.ownedVecs.get(n).add(i);
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public RandomBallCover<V> clone() {
        return new RandomBallCover<V>(this);
    }

    public static class RandomBallCoverFactory<V extends Vec>
    implements VectorCollectionFactory<V> {
        private static final long serialVersionUID = 2707446304590604519L;

        @Override
        public VectorCollection<V> getVectorCollection(List<V> source, DistanceMetric distanceMetric) {
            return new RandomBallCover<V>(source, distanceMetric);
        }

        @Override
        public VectorCollection<V> getVectorCollection(List<V> source, DistanceMetric distanceMetric, ExecutorService threadpool) {
            return new RandomBallCover<V>(source, distanceMetric, threadpool);
        }

        @Override
        public VectorCollectionFactory<V> clone() {
            return new RandomBallCoverFactory<V>();
        }
    }
}

