/*
 * Decompiled with CFR 0.152.
 */
package jsat.lossfunctions;

import jsat.lossfunctions.LossR;

public class EpsilonInsensitiveLoss
implements LossR {
    private static final long serialVersionUID = -8735274561429676350L;
    private double eps;

    public static double loss(double pred, double y, double eps) {
        double x = Math.abs(pred - y);
        return Math.max(0.0, x - eps);
    }

    public static double deriv(double pred, double y, double eps) {
        double x = pred - y;
        if (eps < Math.abs(x)) {
            return Math.signum(x);
        }
        return 0.0;
    }

    public EpsilonInsensitiveLoss(double eps) {
        if (eps < 0.0 || Double.isNaN(eps) || Double.isInfinite(eps)) {
            throw new IllegalArgumentException("Epsilon must be non-negative, not " + eps);
        }
        this.eps = eps;
    }

    public EpsilonInsensitiveLoss(EpsilonInsensitiveLoss toCopy) {
        this.eps = toCopy.eps;
    }

    @Override
    public double getLoss(double pred, double y) {
        return EpsilonInsensitiveLoss.loss(pred, y, this.eps);
    }

    @Override
    public double getDeriv(double pred, double y) {
        return EpsilonInsensitiveLoss.deriv(pred, y, this.eps);
    }

    @Override
    public double getDeriv2(double pred, double y) {
        return 0.0;
    }

    @Override
    public double getDeriv2Max() {
        return 0.0;
    }

    @Override
    public EpsilonInsensitiveLoss clone() {
        return new EpsilonInsensitiveLoss(this);
    }

    @Override
    public double getRegression(double score) {
        return score;
    }
}

