/*
 * Decompiled with CFR 0.152.
 */
package jsat.math;

public class FastMath {
    private static final double logConst = Math.log(2.0);
    static final double[] log2Cache11 = new double[2048];
    private static final double expPowConst;

    private static long getMantissa(long bits) {
        return bits & 0xFFFFFFFFFFFFFL;
    }

    private static long getExponent(long bits) {
        return (bits & 0x7FF0000000000000L) >> 52;
    }

    public static double log(double x) {
        return logConst * FastMath.log2(x);
    }

    public static double log2(double x) {
        return FastMath.log2_2pd1(x);
    }

    public static double log2_2pd1(double x) {
        if (x < 0.0) {
            return Double.NaN;
        }
        long rawBits = Double.doubleToLongBits(x);
        long mantissa = FastMath.getMantissa(rawBits);
        int e = Math.getExponent(x);
        double m = Double.longBitsToDouble(0x3FF0000000000000L | mantissa);
        double log2m = 1.847320661499 + 0.240449173481494 * m - 3.651821822250191 / (0.75 + m);
        return log2m + (double)e;
    }

    public static double log2_c11(double x) {
        if (x < 0.0) {
            return Double.NaN;
        }
        long rawBits = Double.doubleToLongBits(x);
        long mantissa = FastMath.getMantissa(rawBits);
        int e = Math.getExponent(x);
        return log2Cache11[(int)(mantissa >>> 41)] + (double)e;
    }

    public static double pow2(int x) {
        if (x > 1023) {
            return Double.POSITIVE_INFINITY;
        }
        if (x < -1022) {
            return 0.0;
        }
        return Double.longBitsToDouble((long)x + 1023L << 52);
    }

    public static double pow2(double x) {
        if (x > 1023.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (x < -1022.0) {
            return 0.0;
        }
        if (x < 0.0) {
            return 1.0 / FastMath.pow2(-x);
        }
        double floorXd = Math.floor(x);
        int floorX = (int)floorXd;
        double frac = x - floorXd;
        double pow2frac = -4.704682932438695 + 27.54376505811332 / (4.828085122666891 - frac) - 0.490129071734273 * frac;
        return pow2frac * Double.longBitsToDouble((long)floorX + 1023L << 52);
    }

    public static double pow(double a, double b) {
        if (b < 0.0) {
            return 1.0 / FastMath.pow(a, -b);
        }
        long rawBits_a = Double.doubleToLongBits(a);
        long mantissa_a = FastMath.getMantissa(rawBits_a);
        int e_a = Math.getExponent(a);
        double m = Double.longBitsToDouble(0x3FF0000000000000L | mantissa_a);
        double log2m = 1.790711564253215 + 0.248597253161674 * m - 3.495545043418375 / (0.714309275671154 + 1.0 * m);
        return FastMath.pow2(b * log2m + b * (double)e_a);
    }

    public static double exp(double x) {
        return FastMath.pow2(expPowConst * x);
    }

    public static double digamma(double x) {
        if (x == 0.0) {
            return Double.NaN;
        }
        if (x < 0.0) {
            if (Math.rint(x) == x) {
                return Double.NaN;
            }
            return FastMath.digamma(1.0 - x) - Math.PI / Math.tan(Math.PI * x);
        }
        double xp2 = x + 2.0;
        return FastMath.log(xp2) - (6.0 * x + 13.0) / (12.0 * xp2 * xp2) - (2.0 * x + 1.0) / (x * x + x);
    }

    static {
        for (int i = 0; i < log2Cache11.length; ++i) {
            long mantissa = i;
            FastMath.log2Cache11[i] = Math.log(Double.longBitsToDouble(0x3FF0000000000000L | (mantissa <<= 41))) / Math.log(2.0);
        }
        expPowConst = 1.0 / Math.log(2.0);
    }
}

