/*
 * Decompiled with CFR 0.152.
 */
package jsat.math.rootfinding;

import jsat.linear.Vec;
import jsat.math.Function;
import jsat.math.rootfinding.RootFinder;

public class RiddersMethod
implements RootFinder {
    private static final long serialVersionUID = 8154909945080099018L;

    public static double root(double a, double b, Function f, double ... args) {
        return RiddersMethod.root(1.0E-15, 1000, a, b, 0, f, args);
    }

    public static double root(double eps, double a, double b, Function f, double ... args) {
        return RiddersMethod.root(eps, 1000, a, b, 0, f, args);
    }

    public static double root(double eps, double a, double b, int pos, Function f, double ... args) {
        return RiddersMethod.root(eps, 1000, a, b, pos, f, args);
    }

    public static double root(double eps, int maxIterations, double x1, double x2, int pos, Function f, double ... args) {
        if (args == null || args.length == 0) {
            pos = 0;
            args = new double[1];
        }
        args[pos] = x1;
        double fx1 = f.f(args);
        args[pos] = x2;
        double fx2 = f.f(args);
        double halfEps = eps * 0.5;
        if (fx1 * fx2 >= 0.0) {
            throw new ArithmeticException("The given interval does not appear to bracket the root");
        }
        double dif = 1.0;
        while (Math.abs(x1 - x2) > eps && maxIterations-- > 0) {
            double x4;
            double x3;
            args[pos] = x3 = (x1 + x2) * 0.5;
            double fx3 = f.f(args);
            args[pos] = x4 = x3 + (x3 - x1) * Math.signum(fx1 - fx2) * fx3 / Math.sqrt(fx3 * fx3 - fx1 * fx2);
            double fx4 = f.f(args);
            if (fx3 * fx4 < 0.0) {
                x1 = x3;
                fx1 = fx3;
                x2 = x4;
                fx2 = fx4;
                continue;
            }
            if (fx1 * fx4 < 0.0) {
                dif = Math.abs(x4 - x2);
                if (dif <= halfEps) {
                    return x4;
                }
                x2 = x4;
                fx2 = fx4;
                continue;
            }
            dif = Math.abs(x4 - x1);
            if (dif <= halfEps) {
                return x4;
            }
            x1 = x4;
            fx1 = fx4;
        }
        return x2;
    }

    @Override
    public double root(double eps, int maxIterations, double[] initialGuesses, Function f, int pos, double ... args) {
        return RiddersMethod.root(eps, maxIterations, initialGuesses[0], initialGuesses[1], pos, f, args);
    }

    @Override
    public double root(double eps, int maxIterations, double[] initialGuesses, Function f, int pos, Vec args) {
        return RiddersMethod.root(eps, maxIterations, initialGuesses[0], initialGuesses[1], pos, f, args.arrayCopy());
    }

    @Override
    public int guessesNeeded() {
        return 2;
    }
}

