/*
 * Decompiled with CFR 0.152.
 */
package jsat.utils;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import jsat.utils.IntList;

public class IntSortedSet
extends AbstractSet<Integer>
implements Serializable,
SortedSet<Integer> {
    private static final long serialVersionUID = -2675363824037596497L;
    private static final int defaultSize = 8;
    private int[] store;
    private int size;

    public IntSortedSet(int initialSize) {
        this.store = new int[initialSize];
        this.size = 0;
    }

    public IntSortedSet(Set<Integer> set) {
        this(set.size());
        for (Integer integer : set) {
            this.add(integer);
        }
    }

    public IntSortedSet(Collection<Integer> collection) {
        this();
        for (Integer integer : collection) {
            this.add(integer);
        }
    }

    public static IntSortedSet from(int ... ints) {
        return new IntSortedSet(IntList.view(ints, ints.length));
    }

    public IntSortedSet() {
        this(8);
    }

    @Override
    public boolean add(Integer e) {
        if (e == null) {
            return false;
        }
        int insertionPoint = Arrays.binarySearch(this.store, 0, this.size, e);
        if (insertionPoint >= 0) {
            return false;
        }
        insertionPoint = -insertionPoint - 1;
        if (this.size >= this.store.length) {
            this.store = Arrays.copyOf(this.store, Math.max(1, this.store.length) * 2);
        }
        for (int i = this.size; i > insertionPoint; --i) {
            this.store[i] = this.store[i - 1];
        }
        this.store[insertionPoint] = e;
        ++this.size;
        return true;
    }

    public boolean contains(int o) {
        int insertionPoint = Arrays.binarySearch(this.store, 0, this.size, o);
        return insertionPoint >= 0;
    }

    @Override
    public boolean contains(Object o) {
        if (o != null && o instanceof Integer) {
            return this.contains((Integer)o);
        }
        return false;
    }

    @Override
    public Iterator<Integer> iterator() {
        Iterator<Integer> iterator = new Iterator<Integer>(){
            int index = 0;
            boolean canRemove = false;

            @Override
            public boolean hasNext() {
                return this.index < IntSortedSet.this.size;
            }

            @Override
            public Integer next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("The whole set has been iterated");
                }
                this.canRemove = true;
                return IntSortedSet.this.store[this.index++];
            }

            @Override
            public void remove() {
                if (!this.canRemove) {
                    throw new IllegalStateException("Can not remove, remove can only occur after a successful call to next");
                }
                for (int i = this.index; i < IntSortedSet.this.size; ++i) {
                    ((IntSortedSet)IntSortedSet.this).store[i - 1] = IntSortedSet.this.store[i];
                }
                --this.index;
                IntSortedSet.this.size--;
                this.canRemove = false;
            }
        };
        return iterator;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Comparator<? super Integer> comparator() {
        return new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return o1.compareTo(o2);
            }
        };
    }

    @Override
    public SortedSet<Integer> subSet(Integer fromElement, Integer toElement) {
        if (fromElement > toElement) {
            throw new IllegalArgumentException("fromKey was > toKey");
        }
        return new IntSortedSubSet(fromElement, toElement - 1, this);
    }

    @Override
    public SortedSet<Integer> headSet(Integer toElement) {
        return new IntSortedSubSet(Integer.MIN_VALUE, toElement - 1, this);
    }

    @Override
    public SortedSet<Integer> tailSet(Integer fromElement) {
        return new IntSortedSubSet(fromElement, 0x7FFFFFFE, this);
    }

    @Override
    public Integer first() {
        return this.store[0];
    }

    @Override
    public Integer last() {
        return this.store[this.size - 1];
    }

    private class IntSortedSubSet
    extends AbstractSet<Integer>
    implements Serializable,
    SortedSet<Integer> {
        int minValidValue;
        int maxValidValue;
        IntSortedSet parent;

        public IntSortedSubSet(int minValidValue, int maxValidValue, IntSortedSet parent) {
            this.minValidValue = minValidValue;
            this.maxValidValue = maxValidValue;
            this.parent = parent;
        }

        @Override
        public boolean add(Integer e) {
            if (e == null) {
                return false;
            }
            if (e < this.minValidValue || e > this.maxValidValue) {
                throw new IllegalArgumentException("You can not add to a sub-set view outside of the constructed range");
            }
            return this.parent.add(e);
        }

        public boolean contains(int o) {
            if (o < this.minValidValue || o > this.maxValidValue) {
                return false;
            }
            return this.parent.contains(o);
        }

        @Override
        public boolean contains(Object o) {
            if (o != null && o instanceof Integer) {
                return this.contains((Integer)o);
            }
            return false;
        }

        @Override
        public Iterator<Integer> iterator() {
            int start = Arrays.binarySearch(IntSortedSet.this.store, 0, IntSortedSet.this.size, this.minValidValue);
            if (start < 0) {
                start = -start - 1;
            }
            final int start_pos = start;
            Iterator<Integer> iterator = new Iterator<Integer>(){
                int index;
                boolean canRemove;
                {
                    this.index = start_pos;
                    this.canRemove = false;
                }

                @Override
                public boolean hasNext() {
                    return this.index < IntSortedSet.this.size && IntSortedSet.this.store[this.index] <= IntSortedSubSet.this.maxValidValue;
                }

                @Override
                public Integer next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException("The whole set has been iterated");
                    }
                    this.canRemove = true;
                    return IntSortedSet.this.store[this.index++];
                }

                @Override
                public void remove() {
                    if (!this.canRemove) {
                        throw new IllegalStateException("Can not remove, remove can only occur after a successful call to next");
                    }
                    for (int i = this.index; i < IntSortedSet.this.size; ++i) {
                        ((IntSortedSet)IntSortedSet.this).store[i - 1] = IntSortedSet.this.store[i];
                    }
                    --this.index;
                    IntSortedSet.this.size--;
                    this.canRemove = false;
                }
            };
            return iterator;
        }

        @Override
        public int size() {
            int end;
            int start = Arrays.binarySearch(IntSortedSet.this.store, 0, IntSortedSet.this.size, this.minValidValue);
            if (start < 0) {
                start = -start - 1;
            }
            if ((end = Arrays.binarySearch(IntSortedSet.this.store, 0, IntSortedSet.this.size, this.maxValidValue)) < 0) {
                end = -end - 1;
            }
            if (end < IntSortedSet.this.size && IntSortedSet.this.store[end] == this.maxValidValue) {
                ++end;
            }
            return end - start;
        }

        @Override
        public Comparator<? super Integer> comparator() {
            return this.parent.comparator();
        }

        @Override
        public SortedSet<Integer> subSet(Integer fromElement, Integer toElement) {
            if (fromElement > toElement) {
                throw new IllegalArgumentException("fromKey was > toKey");
            }
            return this.parent.subSet(Math.max(this.minValidValue, fromElement), Math.min(this.maxValidValue + 1, toElement));
        }

        @Override
        public SortedSet<Integer> headSet(Integer toElement) {
            return new IntSortedSubSet(Math.max(Integer.MIN_VALUE, this.minValidValue), Math.min(toElement - 1, this.maxValidValue), this.parent);
        }

        @Override
        public SortedSet<Integer> tailSet(Integer fromElement) {
            return new IntSortedSubSet(Math.max(fromElement, this.minValidValue), Math.min(0x7FFFFFFE, this.maxValidValue), this.parent);
        }

        @Override
        public Integer first() {
            int start = Arrays.binarySearch(IntSortedSet.this.store, 0, IntSortedSet.this.size, this.minValidValue);
            if (start < 0) {
                start = -start - 1;
            }
            return IntSortedSet.this.store[start];
        }

        @Override
        public Integer last() {
            int pos = Arrays.binarySearch(IntSortedSet.this.store, 0, IntSortedSet.this.size, this.maxValidValue);
            if (pos < 0) {
                pos = -pos - 1;
            }
            while (pos >= 0 && IntSortedSet.this.store[pos] > this.maxValidValue) {
                --pos;
            }
            return IntSortedSet.this.store[pos];
        }
    }
}

