/*
 * Decompiled with CFR 0.152.
 */
package jsat.utils.concurrent;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class TreeBarrier {
    private final int parties;
    private Lock[] locks;
    private volatile boolean competitionCondition;

    public TreeBarrier(int parties) {
        this.parties = parties;
        this.locks = new Lock[parties - 1];
        for (int i = 0; i < this.locks.length; ++i) {
            this.locks[i] = new ReentrantLock(false);
        }
        this.competitionCondition = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void await(int ID) throws InterruptedException {
        if (this.parties == 1) {
            return;
        }
        boolean startCondition = this.competitionCondition;
        int competingFor = (this.locks.length * 2 - 1 - ID) / 2;
        while (competingFor >= 0) {
            Lock node = this.locks[competingFor];
            if (node.tryLock()) {
                Lock lock = node;
                synchronized (lock) {
                    while (this.competitionCondition == startCondition) {
                        node.wait();
                    }
                }
                node.unlock();
                this.wakeUpTarget(competingFor * 2 + 1);
                this.wakeUpTarget(competingFor * 2 + 2);
                return;
            }
            if (competingFor == 0) break;
            competingFor = (competingFor - 1) / 2;
        }
        this.competitionCondition = !this.competitionCondition;
        this.wakeUpTarget(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeUpTarget(int nodeID) {
        if (nodeID < this.locks.length) {
            Lock lock = this.locks[nodeID];
            synchronized (lock) {
                this.locks[nodeID].notify();
            }
        }
    }
}

