/*
 * Decompiled with CFR 0.152.
 */
package jsat;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import jsat.DataSet;
import jsat.SimpleDataSet;
import jsat.classifiers.CategoricalData;
import jsat.classifiers.DataPoint;
import jsat.clustering.kmeans.HamerlyKMeans;
import jsat.linear.DenseVector;
import jsat.linear.Vec;
import jsat.math.OnLineStatistics;
import jsat.utils.random.XORWOW;

public class KMeansRandomSwap {
    public static void main(String ... args) {
        XORWOW rand = new XORWOW();
        ExecutorService ex = Executors.newCachedThreadPool();
        int N = 100000;
        int D = 2000;
        int trials = 400;
        HamerlyKMeans kmeans = new HamerlyKMeans();
        boolean sphere = false;
        for (int k = 2; k < 20; ++k) {
            SimpleDataSet sds = new SimpleDataSet(new CategoricalData[0], D);
            for (int i = 0; i < N; ++i) {
                Vec x = DenseVector.random(D, rand);
                if (sphere) {
                    x.mutableDivide(x.pNorm(2.0));
                }
                sds.add(new DataPoint(x));
            }
            int[] designations = new int[N];
            OnLineStatistics avgNumSameCluster_ = new OnLineStatistics();
            for (int trial = 0; trial < trials; ++trial) {
                kmeans.cluster((DataSet)sds, k, ex, designations);
                for (int i = 0; i < designations.length; ++i) {
                    for (int j = i + 1; j < designations.length; ++j) {
                        if (designations[i] == designations[j]) {
                            avgNumSameCluster_.add(1.0);
                            continue;
                        }
                        avgNumSameCluster_.add(0.0);
                    }
                }
            }
            System.out.println(1.0 / (double)k + ", " + avgNumSameCluster_.getMean() + "(" + avgNumSameCluster_.getStandardDeviation() + ")");
        }
        ex.shutdownNow();
    }
}

