/*
 * Decompiled with CFR 0.152.
 */
package jsat;

import java.util.ArrayList;
import jsat.classifiers.CategoricalData;
import jsat.classifiers.ClassificationDataSet;
import jsat.classifiers.DataPoint;
import jsat.classifiers.trees.DecisionTree;
import jsat.linear.DenseVector;

public class LukazTest {
    public static void main(String ... args) {
        CategoricalData[] cd = new CategoricalData[4];
        cd[0] = new CategoricalData(3);
        cd[0].setCategoryName("response");
        cd[1] = new CategoricalData(2);
        cd[1].setCategoryName("feature1");
        cd[2] = new CategoricalData(2);
        cd[2].setCategoryName("feature2");
        cd[3] = new CategoricalData(2);
        cd[3].setCategoryName("feature3");
        ArrayList<DataPoint> datapoints = new ArrayList<DataPoint>(150);
        for (int i = 1; i <= 150; ++i) {
            int[] catFields = new int[4];
            catFields[0] = i % 3;
            catFields[i % 3 + 1] = 1;
            DataPoint point = new DataPoint(new DenseVector(new double[0]), catFields, cd);
            datapoints.add(point);
        }
        ClassificationDataSet trainSet = new ClassificationDataSet(datapoints, 0);
        DecisionTree model = DecisionTree.getC45Tree();
        model.trainC(trainSet);
        System.out.println(trainSet.getNumNumericalVars());
        System.out.println(trainSet.getNumCategoricalVars());
        try {
            int[] catFields = new int[]{2, 0, 0, 1};
            DataPoint dp = new DataPoint(new DenseVector(new double[0]), catFields, cd);
            model.classify(dp);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

