/*
 * Decompiled with CFR 0.152.
 */
package jsat;

import java.io.File;
import java.io.IOException;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import jsat.ARFFLoader;
import jsat.classifiers.CategoricalData;
import jsat.classifiers.ClassificationDataSet;
import jsat.classifiers.ClassificationModelEvaluation;
import jsat.classifiers.OneVSAll;
import jsat.classifiers.svm.extended.CPM;
import jsat.linear.DenseVector;
import jsat.utils.SystemInfo;
import jsat.utils.random.XORWOW;

public class MINST_test {
    public static ClassificationDataSet swissRoll(int N) {
        int classes = 10;
        XORWOW rand = new XORWOW();
        double max = 14.137166941154069;
        ClassificationDataSet cds = new ClassificationDataSet(3, new CategoricalData[0], new CategoricalData(classes));
        for (int i = 0; i < N; ++i) {
            double r = ((Random)rand).nextDouble();
            double t = (r * 2.0 + 1.0) * 1.5 * Math.PI;
            cds.addDataPoint(DenseVector.toDenseVec(t * Math.cos(t), 12.6 * ((Random)rand).nextDouble(), t * Math.sin(t)), (int)Math.round(r * (double)classes));
        }
        return cds;
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        String path = "/Users/eman7613/Desktop/";
        String train = "MNISTtrain.arff";
        String test = "MNISTtest.arff";
        ClassificationDataSet trainSet = new ClassificationDataSet(ARFFLoader.loadArffFile(new File(path, train)), 0);
        ClassificationDataSet testSet = new ClassificationDataSet(ARFFLoader.loadArffFile(new File(path, test)), 0);
        ExecutorService ex = Executors.newFixedThreadPool(SystemInfo.LogicalCores);
        ClassificationModelEvaluation cme = new ClassificationModelEvaluation(new OneVSAll(new CPM(), true), trainSet, ex);
        cme.evaluateTestSet(testSet);
        System.out.println(cme.getErrorRate());
        System.out.println(cme.getTotalTrainingTime());
        int k = 20;
        ex.shutdownNow();
    }
}

