/*
 * Decompiled with CFR 0.152.
 */
package jsat.datatransform.visualization;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import jsat.DataSet;
import jsat.SimpleDataSet;
import jsat.datatransform.visualization.MDS;
import jsat.datatransform.visualization.VisualizationTransform;
import jsat.linear.DenseMatrix;
import jsat.linear.Matrix;
import jsat.linear.Vec;
import jsat.linear.VecPaired;
import jsat.linear.distancemetrics.DistanceMetric;
import jsat.linear.distancemetrics.EuclideanDistance;
import jsat.linear.vectorcollection.DefaultVectorCollectionFactory;
import jsat.linear.vectorcollection.VectorCollection;
import jsat.linear.vectorcollection.VectorCollectionFactory;
import jsat.utils.FakeExecutor;
import jsat.utils.FibHeap;
import jsat.utils.SystemInfo;

public class Isomap
implements VisualizationTransform {
    private DistanceMetric dm = new EuclideanDistance();
    private VectorCollectionFactory<VecPaired<Vec, Integer>> vcf = new DefaultVectorCollectionFactory<VecPaired<Vec, Integer>>();
    private int searchNeighbors = 15;
    private MDS mds = new MDS();
    private boolean c_isomap = false;

    public Isomap() {
        this(15, false);
    }

    public Isomap(int searchNeighbors) {
        this(searchNeighbors, false);
    }

    public Isomap(int searchNeighbors, boolean c_isomap) {
        this.setNeighbors(searchNeighbors);
        this.setCIsomap(c_isomap);
    }

    public void setNeighbors(int searchNeighbors) {
        if (searchNeighbors < 2) {
            throw new IllegalArgumentException("number of neighbors considered must be at least 2, not " + searchNeighbors);
        }
        this.searchNeighbors = searchNeighbors;
    }

    public int getNeighbors() {
        return this.searchNeighbors;
    }

    public void setCIsomap(boolean c_isomap) {
        this.c_isomap = c_isomap;
    }

    public boolean isCIsomap() {
        return this.c_isomap;
    }

    @Override
    public <Type extends DataSet> Type transform(DataSet<Type> d) {
        return this.transform(d, new FakeExecutor());
    }

    @Override
    public <Type extends DataSet> Type transform(DataSet<Type> d, ExecutorService ex) {
        final int N = d.getSampleSize();
        final DenseMatrix delta = new DenseMatrix(N, N);
        for (int i = 0; i < N; ++i) {
            for (int j = 0; j < N; ++j) {
                if (i == j) {
                    ((Matrix)delta).set(i, j, 0.0);
                    continue;
                }
                ((Matrix)delta).set(i, j, Double.MAX_VALUE);
            }
        }
        final ArrayList<VecPaired<Vec, Integer>> vecs = new ArrayList<VecPaired<Vec, Integer>>(N);
        for (int i = 0; i < N; ++i) {
            vecs.add(new VecPaired<Vec, Integer>(d.getDataPoint(i).getNumericalValues(), i));
        }
        final VectorCollection<VecPaired<Vec, Integer>> vc = this.vcf.getVectorCollection(vecs, this.dm, ex);
        final List<Double> cache = this.dm.getAccelerationCache(vecs, ex);
        final int knn = this.searchNeighbors + 1;
        final ArrayList neighborGraph = new ArrayList();
        for (int i = 0; i < N; ++i) {
            neighborGraph.add(null);
        }
        final double[] avgNeighborDist = new double[N];
        final CountDownLatch latch1 = new CountDownLatch(SystemInfo.LogicalCores);
        int id = 0;
        while (id < SystemInfo.LogicalCores) {
            final int ID = id++;
            ex.submit(new Runnable(){

                @Override
                public void run() {
                    for (int i = ID; i < N; i += SystemInfo.LogicalCores) {
                        List neighbors = vc.search((Vec)((VecPaired)vecs.get(i)).getVector(), knn);
                        neighborGraph.set(i, neighbors);
                        for (int z = 1; z < neighbors.size(); ++z) {
                            VecPaired neighbor = neighbors.get(z);
                            double dist = neighbor.getPair();
                            int n = i;
                            avgNeighborDist[n] = avgNeighborDist[n] + dist;
                        }
                        int n = i;
                        avgNeighborDist[n] = avgNeighborDist[n] / (double)(neighbors.size() - 1);
                    }
                    latch1.countDown();
                }
            });
        }
        try {
            latch1.await();
        }
        catch (InterruptedException ex1) {
            Logger.getLogger(Isomap.class.getName()).log(Level.SEVERE, null, ex1);
        }
        if (this.c_isomap) {
            int i = 0;
            for (List neighbors : neighborGraph) {
                for (VecPaired neighbor : neighbors) {
                    neighbor.setPair((Double)neighbor.getPair() / Math.sqrt(avgNeighborDist[(Integer)((VecPaired)neighbor.getVector()).getPair()] + avgNeighborDist[i] + 1.0E-6));
                }
                ++i;
            }
        }
        final CountDownLatch latch2 = new CountDownLatch(SystemInfo.LogicalCores);
        int id2 = 0;
        while (id2 < SystemInfo.LogicalCores) {
            final int ID = id2++;
            ex.submit(new Runnable(){

                @Override
                public void run() {
                    for (int k = ID; k < N; k += SystemInfo.LogicalCores) {
                        double[] tmp_dist = Isomap.this.dijkstra(neighborGraph, k);
                        for (int i = 0; i < N; ++i) {
                            tmp_dist[i] = Math.min(tmp_dist[i], delta.get(k, i));
                            delta.set(i, k, tmp_dist[i]);
                            delta.set(k, i, tmp_dist[i]);
                        }
                    }
                    latch2.countDown();
                }
            });
        }
        try {
            latch2.await();
        }
        catch (InterruptedException ex1) {
            Logger.getLogger(Isomap.class.getName()).log(Level.SEVERE, null, ex1);
        }
        double largest_natural_dist_tmp = 0.0;
        for (int i = 0; i < N; ++i) {
            for (int j = i + 1; j < N; ++j) {
                if (!(((Matrix)delta).get(i, j) < Double.MAX_VALUE)) continue;
                largest_natural_dist_tmp = Math.max(largest_natural_dist_tmp, ((Matrix)delta).get(i, j));
            }
        }
        final double largest_natural_dist = largest_natural_dist_tmp;
        final CountDownLatch latch3 = new CountDownLatch(SystemInfo.LogicalCores);
        int id3 = 0;
        while (id3 < SystemInfo.LogicalCores) {
            final int ID = id3++;
            ex.submit(new Runnable(){

                @Override
                public void run() {
                    for (int i = ID; i < N; i += SystemInfo.LogicalCores) {
                        for (int j = i + 1; j < N; ++j) {
                            double d_ij = delta.get(i, j);
                            if (!(d_ij >= Double.MAX_VALUE)) continue;
                            d_ij = 10.0 * Isomap.this.dm.dist(i, j, (List<? extends Vec>)vecs, (List<Double>)cache) + 1.5 * largest_natural_dist;
                            delta.set(i, j, d_ij);
                            delta.set(j, i, d_ij);
                        }
                        latch3.countDown();
                    }
                }
            });
        }
        try {
            latch3.await();
        }
        catch (InterruptedException ex1) {
            Logger.getLogger(Isomap.class.getName()).log(Level.SEVERE, null, ex1);
        }
        SimpleDataSet emedded = this.mds.transform(delta, ex);
        DataSet<Type> transformed = d.shallowClone();
        transformed.replaceNumericFeatures(emedded.getDataVectors());
        return (Type)transformed;
    }

    private double[] dijkstra(List<List<? extends VecPaired<VecPaired<Vec, Integer>, Double>>> neighborGraph, int sourceIndex) {
        int N = neighborGraph.size();
        double[] dist = new double[N];
        Arrays.fill(dist, Double.POSITIVE_INFINITY);
        dist[sourceIndex] = 0.0;
        ArrayList<FibHeap.FibNode<Integer>> nodes = new ArrayList<FibHeap.FibNode<Integer>>(N);
        FibHeap<Integer> Q = new FibHeap<Integer>();
        for (int i = 0; i < N; ++i) {
            nodes.add(null);
        }
        nodes.set(sourceIndex, Q.insert(sourceIndex, dist[sourceIndex]));
        while (Q.size() > 0) {
            FibHeap.FibNode u = Q.removeMin();
            int u_indx = (Integer)u.getValue();
            List<? extends VecPaired<VecPaired<Vec, Integer>, Double>> neighbors = neighborGraph.get(u_indx);
            for (int z = 1; z < neighbors.size(); ++z) {
                VecPaired<VecPaired<Vec, Integer>, Double> neighbor = neighbors.get(z);
                int j = neighbor.getVector().getPair();
                double u_j_dist = neighbor.getPair();
                double alt = dist[u_indx] + u_j_dist;
                if (!(alt < dist[j])) continue;
                dist[j] = alt;
                if (nodes.get(j) == null) {
                    nodes.set(j, Q.insert(j, alt));
                    continue;
                }
                Q.decreaseKey((FibHeap.FibNode)nodes.get(j), alt);
            }
        }
        return dist;
    }

    @Override
    public int getTargetDimension() {
        return this.mds.getTargetDimension();
    }

    @Override
    public boolean setTargetDimension(int target) {
        return this.mds.setTargetDimension(target);
    }
}

