/*
 * Decompiled with CFR 0.152.
 */
package jsat.distributions.multivariate;

import java.util.List;
import java.util.concurrent.ExecutorService;
import jsat.DataSet;
import jsat.classifiers.DataPoint;
import jsat.distributions.multivariate.MultivariateDistribution;
import jsat.linear.DenseVector;
import jsat.linear.Vec;

public abstract class MultivariateDistributionSkeleton
implements MultivariateDistribution {
    private static final long serialVersionUID = 4080753806798149915L;

    @Override
    public double logPdf(double ... x) {
        return this.logPdf(DenseVector.toDenseVec(x));
    }

    @Override
    public double logPdf(Vec x) {
        double logPDF = Math.log(this.pdf(x));
        if (Double.isInfinite(logPDF) && logPDF < 0.0) {
            return -1.7976931348623157E308;
        }
        return logPDF;
    }

    @Override
    public double pdf(double ... x) {
        return this.pdf(DenseVector.toDenseVec(x));
    }

    @Override
    public boolean setUsingData(DataSet dataSet) {
        return this.setUsingDataList(dataSet.getDataPoints());
    }

    @Override
    public boolean setUsingData(DataSet dataSet, ExecutorService threadpool) {
        return this.setUsingDataList(dataSet.getDataPoints(), threadpool);
    }

    @Override
    public <V extends Vec> boolean setUsingData(List<V> dataSet, ExecutorService threadpool) {
        return this.setUsingData(dataSet);
    }

    @Override
    public boolean setUsingDataList(List<DataPoint> dataPoints, ExecutorService threadpool) {
        return this.setUsingDataList(dataPoints);
    }

    @Override
    public abstract MultivariateDistribution clone();
}

