/*
 * Decompiled with CFR 0.152.
 */
package jsat.linear;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import jsat.linear.IndexValue;
import jsat.linear.Vec;

public class Poly2Vec
extends Vec {
    private static final long serialVersionUID = -5653680966558726340L;
    private Vec base;
    private int[] reverseIndex;

    public Poly2Vec(Vec base) {
        this.setBase(base);
    }

    public void setBase(Vec base) {
        this.base = base;
    }

    private int[] getReverseIndex() {
        if (this.reverseIndex != null && this.reverseIndex.length == this.base.length()) {
            Arrays.fill(this.reverseIndex, 0);
        } else {
            this.reverseIndex = new int[this.base.length()];
        }
        this.reverseIndex[0] = this.base.length();
        for (int i = 1; i < this.reverseIndex.length; ++i) {
            this.reverseIndex[i] = this.reverseIndex[i - 1] + (this.base.length() - i);
        }
        return this.reverseIndex;
    }

    @Override
    public int length() {
        return (this.base.length() + 2) * (this.base.length() + 1) / 2;
    }

    @Override
    public int nnz() {
        return (this.base.nnz() + 2) * (this.base.nnz() + 1) / 2;
    }

    @Override
    public double get(int index) {
        if (index == 0) {
            return 1.0;
        }
        if (index <= this.base.length()) {
            return this.base.get(index - 1);
        }
        if (index >= this.length()) {
            throw new IndexOutOfBoundsException("Vector is of length " + this.length() + ", but index " + index + " was requested");
        }
        int x = Arrays.binarySearch(this.getReverseIndex(), index - this.base.length() - 1);
        x = x < 0 ? -x - 1 : ++x;
        double xVal = this.base.get(x);
        int y = (x * x + x) / 2 + (index - this.base.length() - 1) - this.base.length() * x;
        return xVal * this.base.get(y);
    }

    @Override
    public void set(int index, double val) {
        throw new UnsupportedOperationException("Poly2Vec may not be altered");
    }

    @Override
    public boolean isSparse() {
        return this.base.isSparse();
    }

    @Override
    public Vec clone() {
        return new Poly2Vec(this.base.clone());
    }

    @Override
    public Iterator<IndexValue> getNonZeroIterator(int start) {
        Iterator<IndexValue> startInerIter;
        Iterator<IndexValue> startOuterIter;
        int startStage;
        if (this.base.nnz() == 0) {
            return new Iterator<IndexValue>(){
                boolean hasNext = true;

                @Override
                public boolean hasNext() {
                    return this.hasNext;
                }

                @Override
                public IndexValue next() {
                    if (!this.hasNext) {
                        throw new NoSuchElementException("Iterator is empty");
                    }
                    this.hasNext = false;
                    return new IndexValue(0, 1.0);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Not supported yet.");
                }
            };
        }
        boolean stage1Good = true;
        if (start == 0) {
            startStage = 0;
            startOuterIter = null;
            startInerIter = null;
        } else if (start <= this.base.length() && (stage1Good = this.base.getNonZeroIterator(start - 1).hasNext())) {
            startStage = 1;
            startOuterIter = this.base.getNonZeroIterator(start - 1);
            startInerIter = null;
        } else if (start >= this.length()) {
            startStage = 3;
            startOuterIter = null;
            startInerIter = null;
        } else {
            Iterator<IndexValue> candidateInerIter;
            Iterator<IndexValue> candidateOuterIter;
            if (!stage1Good) {
                start = this.base.length() + 1;
            }
            --start;
            do {
                int x;
                x = (x = Arrays.binarySearch(this.getReverseIndex(), ++start - this.base.length() - 1)) < 0 ? -x - 1 : ++x;
                int y = (x * x + x) / 2 + (start - this.base.length() - 1) - this.base.length() * x;
                candidateOuterIter = this.base.getNonZeroIterator(x);
                int nextXIndex = candidateOuterIter.hasNext() ? this.base.getNonZeroIterator(x).next().getIndex() : -1;
                candidateInerIter = candidateOuterIter.hasNext() && nextXIndex > x ? this.base.getNonZeroIterator(nextXIndex) : this.base.getNonZeroIterator(y);
            } while ((!candidateOuterIter.hasNext() || !candidateInerIter.hasNext()) && start < this.length());
            if (candidateOuterIter.hasNext() && candidateInerIter.hasNext() && start < this.length()) {
                startStage = 2;
                startOuterIter = candidateOuterIter;
                startInerIter = candidateInerIter;
            } else {
                return new Iterator<IndexValue>(){

                    @Override
                    public boolean hasNext() {
                        return false;
                    }

                    @Override
                    public IndexValue next() {
                        throw new NoSuchElementException("Iterator is empty");
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Not supported yet.");
                    }
                };
            }
        }
        return new Iterator<IndexValue>(){
            int stage;
            Iterator<IndexValue> outerIter;
            Iterator<IndexValue> inerIter;
            IndexValue curOuterVal;
            IndexValue toReturn;
            {
                this.stage = startStage;
                this.outerIter = startOuterIter;
                this.inerIter = startInerIter;
                this.curOuterVal = this.inerIter != null ? this.outerIter.next() : null;
                this.toReturn = new IndexValue(0, 0.0);
            }

            @Override
            public boolean hasNext() {
                return this.stage < 3;
            }

            @Override
            public IndexValue next() {
                if (this.stage == 0) {
                    ++this.stage;
                    this.outerIter = Poly2Vec.this.base.getNonZeroIterator();
                    return new IndexValue(0, 1.0);
                }
                if (this.stage == 1) {
                    IndexValue iv = this.outerIter.next();
                    if (!this.outerIter.hasNext()) {
                        ++this.stage;
                        this.outerIter = Poly2Vec.this.base.getNonZeroIterator();
                        this.curOuterVal = this.outerIter.next();
                        this.inerIter = Poly2Vec.this.base.getNonZeroIterator();
                    }
                    this.toReturn.setIndex(1 + iv.getIndex());
                    this.toReturn.setValue(iv.getValue());
                    return this.toReturn;
                }
                if (this.stage == 2) {
                    IndexValue innerVal = this.inerIter.next();
                    int x = this.curOuterVal.getIndex();
                    int y = innerVal.getIndex();
                    int N = Poly2Vec.this.base.length();
                    this.toReturn.setIndex(1 + N + x * N + y - x * (x + 1) / 2);
                    this.toReturn.setValue(this.curOuterVal.getValue() * innerVal.getValue());
                    if (!this.inerIter.hasNext()) {
                        if (!this.outerIter.hasNext()) {
                            ++this.stage;
                            this.inerIter = null;
                            this.outerIter = null;
                        } else {
                            this.curOuterVal = this.outerIter.next();
                            this.inerIter = Poly2Vec.this.base.getNonZeroIterator(this.curOuterVal.getIndex());
                        }
                    }
                    return this.toReturn;
                }
                throw new NoSuchElementException("Iterator is empty");
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        };
    }
}

