/*
 * Decompiled with CFR 0.152.
 */
package jsat.linear.distancemetrics;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import jsat.linear.Vec;
import jsat.linear.distancemetrics.DistanceMetric;

public class DistanceCounter
implements DistanceMetric {
    private DistanceMetric base;
    private AtomicLong counter;

    public DistanceCounter(DistanceMetric base) {
        this.base = base;
        this.counter = new AtomicLong();
    }

    public DistanceCounter(DistanceCounter toCopy) {
        this.base = toCopy.base.clone();
        this.counter = toCopy.counter;
    }

    public long getCallCount() {
        return this.counter.get();
    }

    public void resetCounter() {
        this.counter.set(0L);
    }

    @Override
    public double dist(Vec a, Vec b) {
        this.counter.incrementAndGet();
        return this.base.dist(a, b);
    }

    @Override
    public boolean isSymmetric() {
        return this.base.isSymmetric();
    }

    @Override
    public boolean isSubadditive() {
        return this.base.isSubadditive();
    }

    @Override
    public boolean isIndiscemible() {
        return this.base.isIndiscemible();
    }

    @Override
    public double metricBound() {
        return this.base.metricBound();
    }

    @Override
    public boolean supportsAcceleration() {
        return this.base.supportsAcceleration();
    }

    @Override
    public List<Double> getAccelerationCache(List<? extends Vec> vecs) {
        return this.base.getAccelerationCache(vecs);
    }

    @Override
    public List<Double> getAccelerationCache(List<? extends Vec> vecs, ExecutorService threadpool) {
        return this.base.getAccelerationCache(vecs, threadpool);
    }

    @Override
    public double dist(int a, int b, List<? extends Vec> vecs, List<Double> cache) {
        this.counter.incrementAndGet();
        return this.base.dist(a, b, vecs, cache);
    }

    @Override
    public double dist(int a, Vec b, List<? extends Vec> vecs, List<Double> cache) {
        this.counter.incrementAndGet();
        return this.base.dist(a, b, vecs, cache);
    }

    @Override
    public List<Double> getQueryInfo(Vec q) {
        return this.base.getQueryInfo(q);
    }

    @Override
    public double dist(int a, Vec b, List<Double> qi, List<? extends Vec> vecs, List<Double> cache) {
        this.counter.incrementAndGet();
        return this.base.dist(a, b, qi, vecs, cache);
    }

    @Override
    public DistanceCounter clone() {
        return new DistanceCounter(this);
    }
}

