/*
 * Decompiled with CFR 0.152.
 */
package jsat.math;

import jsat.linear.Vec;

public class DescriptiveStatistics {
    public static double sampleCorCoeff(Vec xData, Vec yData) {
        if (yData.length() != xData.length()) {
            throw new ArithmeticException("X and Y data sets must have the same length");
        }
        double xMean = xData.mean();
        double yMean = yData.mean();
        double topSum = 0.0;
        for (int i = 0; i < xData.length(); ++i) {
            topSum += (xData.get(i) - xMean) * (yData.get(i) - yMean);
        }
        return topSum / ((double)(xData.length() - 1) * xData.standardDeviation() * yData.standardDeviation());
    }

    public static double[] summaryStats(Vec xData, Vec yData) {
        int i;
        double[] values = new double[]{xData.sum()};
        values[1] = yData.sum();
        double tmp = 0.0;
        for (i = 0; i < xData.length(); ++i) {
            tmp += Math.pow(xData.get(i), 2.0);
        }
        values[2] = tmp;
        tmp = 0.0;
        for (i = 0; i < xData.length(); ++i) {
            tmp += Math.pow(yData.get(i), 2.0);
        }
        values[3] = tmp;
        tmp = 0.0;
        for (i = 0; i < xData.length(); ++i) {
            tmp += xData.get(i) * yData.get(i);
        }
        values[4] = tmp;
        return values;
    }
}

