/*
 * Decompiled with CFR 0.152.
 */
package jsat.math.optimization;

import java.util.concurrent.ExecutorService;
import jsat.linear.DenseVector;
import jsat.linear.Vec;
import jsat.math.Function;
import jsat.math.FunctionVec;

public class RosenbrockFunction
implements Function {
    private static final long serialVersionUID = -5573482950045304948L;
    public static final FunctionVec GRADIENT = new FunctionVec(){

        @Override
        public Vec f(double ... x) {
            return this.f(DenseVector.toDenseVec(x));
        }

        @Override
        public Vec f(Vec x) {
            Vec s = x.clone();
            this.f(x, s);
            return s;
        }

        @Override
        public Vec f(Vec x, Vec drv) {
            int N = x.length();
            if (drv == null) {
                drv = x.clone();
            }
            drv.zeroOut();
            drv.set(0, -400.0 * x.get(0) * (x.get(1) - Math.pow(x.get(0), 2.0)) - 2.0 * (1.0 - x.get(0)));
            for (int i = 1; i < N - 1; ++i) {
                double x_p = x.get(i - 1);
                double x_i = x.get(i);
                double x_n = x.get(i + 1);
                drv.set(i, 200.0 * (x_i - x_p * x_p) - 400.0 * x_i * (x_n - x_i * x_i) - 2.0 * (1.0 - x_i));
            }
            drv.set(N - 1, 200.0 * (x.get(N - 1) - Math.pow(x.get(N - 2), 2.0)));
            return drv;
        }

        @Override
        public Vec f(Vec x, Vec s, ExecutorService ex) {
            return this.f(x, s);
        }
    };

    @Override
    public double f(double ... x) {
        return this.f(DenseVector.toDenseVec(x));
    }

    @Override
    public double f(Vec x) {
        int N = x.length();
        double f = 0.0;
        for (int i = 1; i < N; ++i) {
            double x_p = x.get(i - 1);
            double xi = x.get(i);
            f += Math.pow(1.0 - x_p, 2.0) + 100.0 * Math.pow(xi - x_p * x_p, 2.0);
        }
        return f;
    }

    public FunctionVec getDerivative() {
        return GRADIENT;
    }
}

